/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.cocoon.util.FileFormatException;
import org.apache.cocoon.util.ImageProperties;
import org.apache.cocoon.util.MIMEUtils;

public final class ImageUtils {
    public static final ImageProperties getImageProperties(File file) throws FileNotFoundException, IOException, FileFormatException {
        String type = MIMEUtils.getMIMEType(file);
        if ("image/gif".equals(type)) {
            return ImageUtils.getGifProperties(file);
        }
        if ("image/jpeg".equals(type)) {
            return ImageUtils.getJpegProperties(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageProperties getJpegProperties(File file) throws FileNotFoundException, IOException, FileFormatException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[2];
            int count = in.read(buf, 0, 2);
            if (count < 2) {
                throw new FileFormatException("Not a valid Jpeg file!");
            }
            if (buf[0] != -1 || buf[1] != -40) {
                throw new FileFormatException("Not a valid Jpeg file!");
            }
            int width = 0;
            int height = 0;
            char[] comment = null;
            boolean hasDims = false;
            boolean hasComment = false;
            int ch = 0;
            while (!(ch == 218 || hasDims && hasComment)) {
                int foo;
                while (ch != 255) {
                    ch = in.read();
                }
                while (ch == 255) {
                    ch = in.read();
                }
                int length = 256 * in.read();
                if ((length += in.read()) < 2) {
                    throw new FileFormatException("Not a valid Jpeg file!");
                }
                if (ch >= 192 && ch <= 195) {
                    in.read();
                    height = 256 * in.read();
                    height += in.read();
                    width = 256 * in.read();
                    width += in.read();
                    for (foo = 0; foo < length - 2 - 5; ++foo) {
                        in.read();
                    }
                    hasDims = true;
                    continue;
                }
                if (ch == 254) {
                    comment = new char[length - 2];
                    for (foo = 0; foo < length - 2; ++foo) {
                        comment[foo] = (char)in.read();
                    }
                    hasComment = true;
                    continue;
                }
                for (foo = 0; foo < length - 2; ++foo) {
                    in.read();
                }
            }
            ImageProperties imageProperties = new ImageProperties(width, height, comment, "jpeg");
            return imageProperties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageProperties getGifProperties(File file) throws FileNotFoundException, IOException, FileFormatException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[10];
            int count = in.read(buf, 0, 10);
            if (count < 10) {
                throw new FileFormatException("Not a valid Gif file!");
            }
            if (buf[0] != 71 || buf[1] != 73 || buf[2] != 70) {
                throw new FileFormatException("Not a valid Gif file!");
            }
            int w1 = buf[6] & 0xFF | buf[6] & 0x80;
            int w2 = buf[7] & 0xFF | buf[7] & 0x80;
            int h1 = buf[8] & 0xFF | buf[8] & 0x80;
            int h2 = buf[9] & 0xFF | buf[9] & 0x80;
            int width = w1 + (w2 << 8);
            int height = h1 + (h2 << 8);
            ImageProperties imageProperties = new ImageProperties(width, height, null, "gif");
            return imageProperties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

