/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.logger.Logger;

public class TraxErrorHandler
implements ErrorListener {
    private StringBuffer warnings = new StringBuffer("Errors in XSLT transformation:\n");
    private Logger logger = null;

    public TraxErrorHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        String message = this.getMessage(exception);
        if (this.logger != null) {
            this.logger.warn(message);
        } else {
            System.out.println("WARNING: " + message);
        }
        this.warnings.append("Warning: ");
        this.warnings.append(message);
        this.warnings.append("\n");
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        String message = this.getMessage(exception);
        if (this.logger != null) {
            this.logger.error(message, (Throwable)exception);
        } else {
            System.out.println("ERROR: " + message);
        }
        this.warnings.append("Error: ");
        this.warnings.append(message);
        this.warnings.append("\n");
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        String message = this.getMessage(exception);
        if (this.logger != null) {
            this.logger.fatalError(message, (Throwable)exception);
        } else {
            System.out.println("FATAL-ERROR: " + message);
        }
        this.warnings.append("Fatal: ");
        this.warnings.append(message);
        this.warnings.append("\n");
        try {
            throw new TransformerException(this.warnings.toString());
        }
        catch (Throwable throwable) {
            this.warnings = new StringBuffer();
            throw throwable;
        }
    }

    private String getMessage(TransformerException exception) {
        SourceLocator locator = exception.getLocator();
        if (null != locator) {
            String id = !locator.getPublicId().equals(locator.getPublicId()) ? locator.getPublicId() : (null != locator.getSystemId() ? locator.getSystemId() : "SystemId Unknown");
            return "File " + id + "; Line " + locator.getLineNumber() + "; Column " + locator.getColumnNumber() + "; " + exception.getMessage();
        }
        return exception.getMessage();
    }
}

