/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DOMStreamer
implements XMLProducer,
Recyclable {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private static final boolean DEFAULT_NORMALIZE_NAMESPACES = true;
    protected boolean normalizeNamespaces = true;
    protected NamespaceNormalizingDOMStreamer namespaceNormalizingDOMStreamer = new NamespaceNormalizingDOMStreamer();
    protected DefaultDOMStreamer defaultDOMStreamer = new DefaultDOMStreamer();

    public DOMStreamer() {
    }

    public DOMStreamer(ContentHandler content, LexicalHandler lexical) {
        this();
        this.setContentHandler(content);
        this.setLexicalHandler(lexical);
    }

    public DOMStreamer(XMLConsumer consumer) {
        this((ContentHandler)((Object)consumer), (LexicalHandler)((Object)consumer));
    }

    public DOMStreamer(ContentHandler content) {
        this(content, content instanceof LexicalHandler ? (LexicalHandler)((Object)content) : null);
    }

    @Override
    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler((ContentHandler)((Object)consumer));
        this.setLexicalHandler((LexicalHandler)((Object)consumer));
    }

    public void setContentHandler(ContentHandler handler) {
        this.defaultDOMStreamer.setContentHandler(handler);
        this.namespaceNormalizingDOMStreamer.setContentHandler(handler);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.defaultDOMStreamer.setLexicalHandler(handler);
        this.namespaceNormalizingDOMStreamer.setLexicalHandler(handler);
    }

    public void stream(Node node) throws SAXException {
        if (this.normalizeNamespaces) {
            this.namespaceNormalizingDOMStreamer.stream(node);
        } else {
            this.defaultDOMStreamer.stream(node);
        }
    }

    public boolean isNormalizeNamespaces() {
        return this.normalizeNamespaces;
    }

    public void setNormalizeNamespaces(boolean normalizeNamespaces) {
        this.normalizeNamespaces = normalizeNamespaces;
    }

    public void recycle() {
        this.defaultDOMStreamer.recycle();
        this.namespaceNormalizingDOMStreamer.recycle();
        this.normalizeNamespaces = true;
    }

    public static class DefaultDOMStreamer
    extends AbstractXMLProducer {
        protected Transformer transformer;

        public void stream(Node node) throws SAXException {
            if (this.transformer == null) {
                try {
                    this.transformer = FACTORY.newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    throw new SAXException(e);
                }
            }
            DOMSource source = new DOMSource(node);
            Object handler = node.getNodeType() == 9 ? this.contentHandler : new EmbeddedXMLPipe(this.contentHandler);
            SAXResult result = new SAXResult((ContentHandler)handler);
            result.setLexicalHandler(this.lexicalHandler);
            try {
                this.transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new SAXException(e);
            }
        }
    }

    public static class NamespaceNormalizingDOMStreamer
    extends AbstractXMLProducer {
        protected ElementInfo currentElementInfo;
        protected int newPrefixCounter;

        @Override
        public void recycle() {
            super.recycle();
            this.currentElementInfo = null;
            this.newPrefixCounter = 0;
        }

        protected void stream(Node pos) throws SAXException {
            boolean isDoc;
            boolean bl = isDoc = pos.getNodeType() == 9;
            if (isDoc) {
                this.contentHandler.startDocument();
            }
            Node top = pos;
            while (null != pos) {
                this.startNode(pos);
                Node nextNode = pos.getFirstChild();
                while (null == nextNode) {
                    this.endNode(pos);
                    if (top.equals(pos)) break;
                    nextNode = pos.getNextSibling();
                    if (null != nextNode || null != (pos = pos.getParentNode()) && !top.equals(pos)) continue;
                    if (null != pos) {
                        this.endNode(pos);
                    }
                    nextNode = null;
                    break;
                }
                pos = nextNode;
            }
            if (isDoc) {
                this.contentHandler.endDocument();
            }
        }

        private final void dispatchChars(Node node) throws SAXException {
            String data = ((Text)node).getData();
            if (data != null) {
                this.contentHandler.characters(data.toCharArray(), 0, data.length());
            }
        }

        protected void startNode(Node node) throws SAXException {
            switch (node.getNodeType()) {
                case 8: {
                    String data;
                    if (this.lexicalHandler == null || (data = ((Comment)node).getData()) == null) break;
                    this.lexicalHandler.comment(data.toCharArray(), 0, data.length());
                    break;
                }
                case 9: 
                case 11: {
                    break;
                }
                case 1: {
                    String uri;
                    NamedNodeMap atts = node.getAttributes();
                    int nAttrs = atts.getLength();
                    this.currentElementInfo = new ElementInfo(this.currentElementInfo);
                    for (int i = 0; i < nAttrs; ++i) {
                        Node attr = atts.item(i);
                        String attrName = attr.getNodeName();
                        if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:")) continue;
                        int index = attrName.indexOf(":");
                        String prefix = index < 0 ? "" : attrName.substring(index + 1);
                        this.currentElementInfo.put(prefix, attr.getNodeValue());
                    }
                    String namespaceURI = node.getNamespaceURI();
                    String prefix = node.getPrefix();
                    String localName = node.getLocalName();
                    if (localName == null) {
                        String[] prefixAndLocalName = this.getPrefixAndLocalName(node.getNodeName());
                        prefix = prefixAndLocalName[0];
                        localName = prefixAndLocalName[1];
                        namespaceURI = this.getNamespaceForPrefix(prefix, (Element)node);
                    }
                    if (namespaceURI != null) {
                        if (prefix == null) {
                            prefix = "";
                        }
                        if (!StringUtils.equals((String)(uri = this.currentElementInfo.findNamespaceURI(prefix)), (String)namespaceURI)) {
                            this.currentElementInfo.put(prefix, namespaceURI);
                        }
                    } else {
                        uri = this.currentElementInfo.findNamespaceURI("");
                        if (StringUtils.isNotEmpty((String)uri)) {
                            this.currentElementInfo.put("", "");
                        }
                    }
                    if (namespaceURI == null) {
                        namespaceURI = "";
                    }
                    String qName = StringUtils.isNotEmpty((String)prefix) ? prefix + ":" + localName : localName;
                    AttributesImpl newAttrs = new AttributesImpl();
                    for (int i = 0; i < nAttrs; ++i) {
                        String attrNsURI;
                        String attrLocalName;
                        String attrPrefix;
                        Node attr = atts.item(i);
                        String attrName = attr.getNodeName();
                        String assignedAttrPrefix = null;
                        if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) continue;
                        if (attr.getLocalName() == null) {
                            String[] prefixAndLocalName = this.getPrefixAndLocalName(attrName);
                            assignedAttrPrefix = attrPrefix = prefixAndLocalName[0];
                            attrLocalName = prefixAndLocalName[1];
                            attrNsURI = attrPrefix != null ? this.getNamespaceForPrefix(attrPrefix, (Element)node) : null;
                        } else {
                            attrLocalName = attr.getLocalName();
                            attrPrefix = attr.getPrefix();
                            attrNsURI = attr.getNamespaceURI();
                        }
                        if (attrNsURI != null) {
                            String declaredUri = this.currentElementInfo.findNamespaceURI(attrPrefix);
                            if (declaredUri == null || !declaredUri.equals(attrNsURI)) {
                                String availablePrefix = this.currentElementInfo.findPrefix(attrNsURI);
                                if (availablePrefix != null && !availablePrefix.equals("")) {
                                    assignedAttrPrefix = availablePrefix;
                                } else if (attrPrefix != null && declaredUri == null) {
                                    assignedAttrPrefix = attrPrefix;
                                    this.currentElementInfo.put(assignedAttrPrefix, attrNsURI);
                                } else {
                                    ++this.newPrefixCounter;
                                    assignedAttrPrefix = "NS" + this.newPrefixCounter;
                                    this.currentElementInfo.put(assignedAttrPrefix, attrNsURI);
                                }
                            } else {
                                assignedAttrPrefix = attrPrefix;
                            }
                        }
                        String assignedAttrNsURI = attrNsURI != null ? attrNsURI : "";
                        String attrQName = assignedAttrPrefix != null ? assignedAttrPrefix + ":" + attrLocalName : attrLocalName;
                        newAttrs.addAttribute(assignedAttrNsURI, attrLocalName, attrQName, "CDATA", attr.getNodeValue());
                    }
                    if (this.currentElementInfo.namespaceDeclarations != null && this.currentElementInfo.namespaceDeclarations.size() > 0) {
                        for (Map.Entry entry : this.currentElementInfo.namespaceDeclarations.entrySet()) {
                            String pr = (String)entry.getKey();
                            String ns = (String)entry.getValue();
                            this.contentHandler.startPrefixMapping(pr, ns);
                        }
                    }
                    this.contentHandler.startElement(namespaceURI, localName, qName, newAttrs);
                    this.currentElementInfo.localName = localName;
                    this.currentElementInfo.namespaceURI = namespaceURI;
                    this.currentElementInfo.qName = qName;
                    break;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    this.contentHandler.processingInstruction(pi.getNodeName(), pi.getData());
                    break;
                }
                case 4: {
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.startCDATA();
                    }
                    this.dispatchChars(node);
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 3: {
                    this.dispatchChars(node);
                    break;
                }
                case 5: {
                    EntityReference eref = (EntityReference)node;
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.startEntity(eref.getNodeName());
                    break;
                }
            }
        }

        public String getNamespaceForPrefix(String prefix, Element namespaceContext) {
            Node parent = namespaceContext;
            String namespace = null;
            if (prefix == null) {
                prefix = "";
            }
            if (prefix.equals("xml")) {
                namespace = "http://www.w3.org/XML/1998/namespace";
            } else if (prefix.equals("xmlns")) {
                namespace = "http://www.w3.org/2000/xmlns/";
            } else {
                short type;
                String declname;
                String string = declname = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
                while (null != parent && ((type = parent.getNodeType()) == 1 || type == 5)) {
                    Attr attr;
                    if (type == 1 && (attr = parent.getAttributeNode(declname)) != null) {
                        namespace = attr.getNodeValue();
                        break;
                    }
                    parent = parent.getParentNode();
                }
            }
            return namespace;
        }

        private String[] getPrefixAndLocalName(String nodeName) {
            String localName;
            String prefix;
            int colonPos = nodeName.indexOf(":");
            if (colonPos != -1) {
                prefix = nodeName.substring(0, colonPos);
                localName = nodeName.substring(colonPos + 1, nodeName.length());
            } else {
                prefix = null;
                localName = nodeName;
            }
            return new String[]{prefix, localName};
        }

        protected void endNode(Node node) throws SAXException {
            switch (node.getNodeType()) {
                case 1: {
                    this.contentHandler.endElement(this.currentElementInfo.namespaceURI, this.currentElementInfo.localName, this.currentElementInfo.qName);
                    if (this.currentElementInfo.namespaceDeclarations != null && this.currentElementInfo.namespaceDeclarations.size() > 0) {
                        for (Map.Entry entry : this.currentElementInfo.namespaceDeclarations.entrySet()) {
                            this.contentHandler.endPrefixMapping((String)entry.getKey());
                        }
                    }
                    this.currentElementInfo = this.currentElementInfo.parent;
                    break;
                }
                case 4: 
                case 9: {
                    break;
                }
                case 5: {
                    EntityReference eref = (EntityReference)node;
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.endEntity(eref.getNodeName());
                    break;
                }
            }
        }

        public static class ElementInfo {
            public String localName;
            public String namespaceURI;
            public String qName;
            public Map namespaceDeclarations = null;
            public ElementInfo parent;

            public ElementInfo(ElementInfo parent) {
                this.parent = parent;
            }

            public void put(String prefix, String namespaceURI) {
                if (this.namespaceDeclarations == null) {
                    this.namespaceDeclarations = new HashMap();
                }
                this.namespaceDeclarations.put(prefix, namespaceURI);
            }

            public String getPrefix(String namespaceURI) {
                if (this.namespaceDeclarations == null || this.namespaceDeclarations.size() == 0) {
                    return null;
                }
                for (Map.Entry entry : this.namespaceDeclarations.entrySet()) {
                    if (!entry.getValue().equals(namespaceURI)) continue;
                    return (String)entry.getKey();
                }
                return null;
            }

            public String getNamespaceURI(String prefix) {
                if (this.namespaceDeclarations == null || this.namespaceDeclarations.size() == 0) {
                    return null;
                }
                return (String)this.namespaceDeclarations.get(prefix);
            }

            public String findPrefix(String namespaceURI) {
                String prefix;
                if (this.namespaceDeclarations != null && this.namespaceDeclarations.size() != 0 && (prefix = this.getPrefix(namespaceURI)) != null) {
                    return prefix;
                }
                if (this.parent != null) {
                    return this.parent.findPrefix(namespaceURI);
                }
                return null;
            }

            public String findNamespaceURI(String prefix) {
                String uri;
                if (this.namespaceDeclarations != null && this.namespaceDeclarations.size() != 0 && (uri = (String)this.namespaceDeclarations.get(prefix)) != null) {
                    return uri;
                }
                if (this.parent != null) {
                    return this.parent.findNamespaceURI(prefix);
                }
                return null;
            }
        }
    }
}

