/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DocumentWrapper
implements Document,
XMLizable {
    protected static final String DOMLEVEL3_ERR_MSG = "This method was just added for providing future compatibility to JDK 1.5's DOM level 3 Document interface.";
    protected final Document document;

    public DocumentWrapper(Document doc) {
        this.document = doc;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        DOMStreamer ds = new DOMStreamer(handler);
        ds.stream(this.document.getDocumentElement());
    }

    public String toString() {
        try {
            return XMLUtils.serializeNode(this.document, XMLUtils.createPropertiesForXML(false));
        }
        catch (ProcessingException processingException) {
            return "";
        }
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    @Override
    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    @Override
    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    @Override
    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    @Override
    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    @Override
    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    @Override
    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public Node getLastChild() {
        return this.document.getLastChild();
    }

    @Override
    public String getLocalName() {
        return this.document.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    @Override
    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    @Override
    public String getNodeName() {
        return this.document.getNodeName();
    }

    @Override
    public short getNodeType() {
        return this.document.getNodeType();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    @Override
    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    @Override
    public Node getParentNode() {
        return this.document.getParentNode();
    }

    @Override
    public String getPrefix() {
        return this.document.getPrefix();
    }

    @Override
    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    @Override
    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    @Override
    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    @Override
    public void normalize() {
        this.document.normalize();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return this.document.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.document.setNodeValue(nodeValue);
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.document.setPrefix(prefix);
    }

    @Override
    public Node renameNode(Node node, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public void normalizeDocument() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public Node adoptNode(Node source) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public void setDocumentURI(String uri) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public void setStrictErrorChecking(boolean value) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public void setXmlVersion(String version) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String getXmlVersion() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public void setXmlStandalone(boolean value) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    public void setXmlEncoding(String version) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String getXmlEncoding() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public Object setUserData(String key, Object value, UserDataHandler handler) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException(DOMLEVEL3_ERR_MSG);
    }
}

