/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.authentication;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.CredentialProviderModel;
import org.ametys.core.authentication.CredentialProviderParameterTypeExtensionPoint;
import org.ametys.core.authentication.DefaultCredentialProviderModel;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ElementDefinitionParser;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerDescriptor;
import org.ametys.runtime.model.checker.ItemCheckerParser;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialProviderFactory
extends AbstractLogEnabled
implements ExtensionPoint<CredentialProviderModel>,
Initializable,
ThreadSafe,
Component,
Serviceable,
Contextualizable,
Disposable {
    public static final String ROLE = CredentialProviderFactory.class.getName();
    protected CredentialProviderParameterTypeExtensionPoint _credentialProviderParameterTypeExtensionPoint;
    private Map<String, CredentialProviderModel> _cpModels;
    private ServiceManager _smanager;
    private Context _context;

    public void initialize() throws Exception {
        this._cpModels = new HashMap<String, CredentialProviderModel>();
    }

    public void dispose() {
        this._cpModels.clear();
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._credentialProviderParameterTypeExtensionPoint = (CredentialProviderParameterTypeExtensionPoint)this._smanager.lookup(CredentialProviderParameterTypeExtensionPoint.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public CredentialProvider createCredentialProvider(String id, String modelId, Map<String, Object> paramsValues, String label) {
        if (this._cpModels.containsKey(modelId)) {
            CredentialProviderModel credentialProviderModel = this._cpModels.get(modelId);
            CredentialProvider cp = null;
            Class<CredentialProvider> cpClass = credentialProviderModel.getCredentialProviderClass();
            try {
                cp = credentialProviderModel.getCredentialProviderClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Cannot instanciate the class " + cpClass.getCanonicalName() + ". Check that there is a public constructor with no arguments.");
            }
            Logger logger = LoggerFactory.getLogger(cpClass);
            try {
                if (cp instanceof LogEnabled) {
                    ((LogEnabled)((Object)cp)).setLogger(logger);
                }
                LifecycleHelper.setupComponent((Object)cp, (org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(logger), (Context)this._context, (ServiceManager)this._smanager, (Configuration)credentialProviderModel.getCredentialProviderConfiguration());
                cp.init(id, modelId, paramsValues, label);
            }
            catch (Exception e) {
                this.getLogger().error("An error occured during the initialization of the CredentialProvider " + id + " [" + modelId + "]", (Throwable)e);
                return null;
            }
            return cp;
        }
        return null;
    }

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        block3: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding credential provider model from plugin " + pluginName + "/" + featureName);
            }
            try {
                this.addCredentialProviderModel(pluginName, configuration);
            }
            catch (ConfigurationException e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("The plugin '" + pluginName + "." + featureName + "' has a credential provider model extension but has an incorrect configuration", (Throwable)e);
            }
        }
    }

    protected void addCredentialProviderModel(String pluginName, Configuration configuration) throws ConfigurationException {
        Configuration[] paramCheckersConfiguration;
        Configuration[] paramsConfiguration;
        String id = configuration.getAttribute("id");
        I18nizableText label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + pluginName);
        I18nizableText description = I18nizableText.parseI18nizableText(configuration.getChild("description"), "plugin." + pluginName);
        I18nizableText connectionLabel = configuration.getChild("label-connection", false) == null ? null : I18nizableText.parseI18nizableText(configuration.getChild("label-connection"), "plugin." + pluginName);
        String iconGlyph = configuration.getChild("icon-glyph").getValue("");
        String iconDecorator = configuration.getChild("icon-decorator").getValue("");
        String iconSmallPath = configuration.getChild("icon-small").getValue("");
        String iconMediumPath = configuration.getChild("icon-medium").getValue("");
        String iconLargePath = configuration.getChild("icon-large").getValue("");
        String connectionColor = configuration.getChild("color").getValue("");
        String className = null;
        Class<CredentialProvider> cpClass = null;
        Configuration classConfig = null;
        try {
            className = configuration.getChild("class").getAttribute("name");
            cpClass = Class.forName(className);
            classConfig = configuration.getChild("class");
        }
        catch (ClassNotFoundException | ConfigurationException e) {
            throw new ConfigurationException("Credential provider model with id '" + id + "' has an invalid configuration for class name '" + (className != null ? className + " <class not found>" : "<missing tag <class>") + "'", e);
        }
        if (!CredentialProvider.class.isAssignableFrom(cpClass)) {
            throw new ConfigurationException("Credential provider model with id '" + id + "' has an invalid configuration: '" + className + "' is not an instance of CredentialProvider");
        }
        LinkedHashMap<String, ElementDefinition> parameters = new LinkedHashMap<String, ElementDefinition>();
        ThreadSafeComponentManager<Validator> validatorManager = new ThreadSafeComponentManager<Validator>();
        validatorManager.setLogger(this.getLogger());
        validatorManager.contextualize(this._context);
        validatorManager.service(this._smanager);
        ThreadSafeComponentManager<Enumerator> enumeratorManager = new ThreadSafeComponentManager<Enumerator>();
        enumeratorManager.setLogger(this.getLogger());
        enumeratorManager.contextualize(this._context);
        enumeratorManager.service(this._smanager);
        CredentialProviderModelParameterParser cpParser = new CredentialProviderModelParameterParser(this._credentialProviderParameterTypeExtensionPoint, enumeratorManager, validatorManager);
        for (Configuration paramConfiguration : paramsConfiguration = configuration.getChild("parameters").getChildren("param")) {
            this.configureParameters(cpParser, paramConfiguration, pluginName, parameters);
        }
        LinkedHashMap<String, ItemCheckerDescriptor> parameterCheckers = new LinkedHashMap<String, ItemCheckerDescriptor>();
        ThreadSafeComponentManager<ItemChecker> parameterCheckerManager = new ThreadSafeComponentManager<ItemChecker>();
        parameterCheckerManager.setLogger(this.getLogger());
        parameterCheckerManager.contextualize(this._context);
        parameterCheckerManager.service(this._smanager);
        ItemCheckerParser parameterCheckerParser = new ItemCheckerParser(parameterCheckerManager);
        for (Configuration paramCheckerConfiguration : paramCheckersConfiguration = configuration.getChild("parameters").getChildren("param-checker")) {
            this.configureParamChecker(parameterCheckerParser, paramCheckerConfiguration, pluginName, parameterCheckers);
        }
        try {
            cpParser.lookupComponents();
            parameterCheckerParser.lookupComponents();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to lookup parameter local components", configuration, (Throwable)e);
        }
        DefaultCredentialProviderModel cpModel = new DefaultCredentialProviderModel(id, cpClass, classConfig, label, description, connectionLabel, iconGlyph, iconDecorator, iconSmallPath, iconMediumPath, iconLargePath, connectionColor, parameters, parameterCheckers, pluginName);
        if (this._cpModels.containsKey(id)) {
            CredentialProviderModel oldCPModel = this._cpModels.get(id);
            throw new IllegalArgumentException("Credential provider model with id '" + id + "' is already declared in plugin '" + oldCPModel.getPluginName() + "'. This second declaration is ignored.");
        }
        this._cpModels.put(id, cpModel);
    }

    protected void configureParameters(CredentialProviderModelParameterParser paramParser, Configuration configuration, String pluginName, Map<String, ElementDefinition> parameters) throws ConfigurationException {
        ElementDefinition elementDefinition = paramParser.parse(this._smanager, pluginName, configuration, null, null);
        String id = elementDefinition.getName();
        if (parameters.containsKey(id)) {
            throw new ConfigurationException("The parameter '" + id + "' is already declared. IDs must be unique.", configuration);
        }
        parameters.put(id, elementDefinition);
    }

    protected void configureParamChecker(ItemCheckerParser parser, Configuration configuration, String pluginName, Map<String, ItemCheckerDescriptor> parameterCheckers) throws ConfigurationException {
        ItemCheckerDescriptor parameterChecker = parser.parseParameterChecker(pluginName, configuration);
        String id = parameterChecker.getName();
        if (parameterCheckers.containsKey(id)) {
            throw new ConfigurationException("The parameter checker '" + id + "' is already declared. IDs must be unique.", configuration);
        }
        parameterCheckers.put(id, parameterChecker);
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    @Override
    public boolean hasExtension(String id) {
        return this._cpModels.containsKey(id);
    }

    @Override
    public CredentialProviderModel getExtension(String id) {
        return this._cpModels.get(id);
    }

    @Override
    public Set<String> getExtensionsIds() {
        return this._cpModels.keySet();
    }

    public class CredentialProviderModelParameterParser
    extends ElementDefinitionParser {
        public CredentialProviderModelParameterParser(CredentialProviderParameterTypeExtensionPoint credentialProviderParameterTypeExtensionPoint, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
            super(credentialProviderParameterTypeExtensionPoint, enumeratorManager, validatorManager);
        }

        @Override
        protected String _getNameConfigurationAttribute() {
            return "id";
        }
    }
}

