/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.captcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.captcha.Captcha;
import nl.captcha.gimpy.DropShadowGimpyRenderer;
import nl.captcha.gimpy.FishEyeGimpyRenderer;
import nl.captcha.gimpy.GimpyRenderer;
import nl.captcha.gimpy.RippleGimpyRenderer;
import nl.captcha.noise.CurvedLineNoiseProducer;
import nl.captcha.noise.NoiseProducer;
import nl.captcha.text.producer.DefaultTextProducer;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.DefaultWordRenderer;
import nl.captcha.text.renderer.WordRenderer;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaptchaHelper
implements Serviceable {
    private static final String CAPTCHA_TYPE_KEY = "runtime.captcha.type";
    private static final String RECAPTCHA_SECRET_KEY = "runtime.captcha.recaptcha.secretkey";
    private static final String STATIC_PREFIX_KEY = "STATIC-";
    private static final String DYNAMIC_PREFIX_KEY = "DYNAMIC-";
    private static Map<String, List<ValidableCaptcha>> _mapStaticCaptcha = new HashMap<String, List<ValidableCaptcha>>();
    private static Map<String, ValidableCaptcha> _mapDynamicCaptcha = new HashMap<String, ValidableCaptcha>();
    private static JSONUtils _jsonUtils;
    private static Logger _logger;

    public void service(ServiceManager manager) throws ServiceException {
        _jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public static String getCaptchaType() {
        if (Config.getInstance() != null) {
            return (String)Config.getInstance().getValue(CAPTCHA_TYPE_KEY);
        }
        return "jcaptcha";
    }

    public static boolean checkAndInvalidate(String key, String value) {
        if (Config.getInstance() != null) {
            String captchaType = (String)Config.getInstance().getValue(CAPTCHA_TYPE_KEY);
            switch (CaptchaType.valueOf(captchaType.toUpperCase())) {
                case JCAPTCHA: {
                    if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
                        return false;
                    }
                    return CaptchaHelper.checkAndInvalidateJCaptcha(key, value);
                }
                case RECAPTCHA: {
                    if (StringUtils.isEmpty((String)value)) {
                        return false;
                    }
                    return CaptchaHelper.checkAndInvalidateReCaptcha(value);
                }
            }
            return false;
        }
        return true;
    }

    public static synchronized boolean checkAndInvalidateJCaptcha(String key, String value) {
        if (key.startsWith(STATIC_PREFIX_KEY)) {
            List<ValidableCaptcha> list = _mapStaticCaptcha.get(key);
            if (list != null) {
                for (ValidableCaptcha c : list) {
                    Captcha captcha;
                    if (!c.isValid() || !(captcha = c.getCaptcha()).isCorrect(value)) continue;
                    c.invalidate();
                    return true;
                }
            }
            return false;
        }
        if (key.startsWith(DYNAMIC_PREFIX_KEY)) {
            ValidableCaptcha vc = _mapDynamicCaptcha.get(key);
            if (vc == null) {
                return false;
            }
            if (!vc.isValid()) {
                _mapDynamicCaptcha.remove(key);
                return false;
            }
            _mapDynamicCaptcha.remove(key);
            Captcha c = vc.getCaptcha();
            return c.isCorrect(value);
        }
        throw new IllegalArgumentException("The key '" + key + "' is not a valid captcha key because it does not starts with '" + DYNAMIC_PREFIX_KEY + "' or '" + STATIC_PREFIX_KEY + "'");
    }

    /*
     * Exception decompiling
     */
    public static boolean checkAndInvalidateReCaptcha(String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized void removeCaptcha(String key) {
        if (key.startsWith(STATIC_PREFIX_KEY)) {
            _mapStaticCaptcha.remove(key);
        } else if (key.startsWith(DYNAMIC_PREFIX_KEY)) {
            _mapDynamicCaptcha.remove(key);
        }
    }

    public static synchronized void cleanOldCaptchas() {
        CaptchaHelper._cleanOldStaticCaptchas();
        CaptchaHelper._cleanOldDynamicCaptchas();
    }

    private static synchronized void _cleanOldDynamicCaptchas() {
        Iterator<String> cIt = _mapDynamicCaptcha.keySet().iterator();
        while (cIt.hasNext()) {
            String id = cIt.next();
            ValidableCaptcha vc = _mapDynamicCaptcha.get(id);
            if (vc.isValid()) continue;
            cIt.remove();
        }
    }

    private static synchronized void _cleanOldStaticCaptchas() {
        Iterator<String> cIt = _mapStaticCaptcha.keySet().iterator();
        while (cIt.hasNext()) {
            String id = cIt.next();
            List<ValidableCaptcha> c = _mapStaticCaptcha.get(id);
            Iterator<ValidableCaptcha> it = c.iterator();
            while (it.hasNext()) {
                ValidableCaptcha vc = it.next();
                if (vc.isValid()) continue;
                it.remove();
            }
            if (!c.isEmpty()) continue;
            cIt.remove();
        }
    }

    public static BufferedImage generateImageCaptcha(String key) {
        return CaptchaHelper.generateImageCaptcha(key, 0);
    }

    public static BufferedImage generateImageCaptcha(String key, boolean addNoise, boolean fisheye) {
        return CaptchaHelper.generateImageCaptcha(key, 0, addNoise, fisheye, 200, 50);
    }

    public static synchronized BufferedImage generateImageCaptcha(String key, Integer color) {
        return CaptchaHelper.generateImageCaptcha(key, color, false, false, 200, 50);
    }

    public static synchronized BufferedImage generateImageCaptcha(String key, Integer color, boolean addNoise, boolean fisheye) {
        return CaptchaHelper.generateImageCaptcha(key, color, addNoise, fisheye, 200, 50);
    }

    public static synchronized BufferedImage generateImageCaptcha(String key, Integer color, boolean addNoise, boolean fisheye, int width, int height) {
        Captcha captcha = CaptchaHelper._generateImageCaptcha(color, addNoise, fisheye, width, height);
        ValidableCaptcha vc = new ValidableCaptcha(captcha);
        if (key.startsWith(STATIC_PREFIX_KEY)) {
            if (!_mapStaticCaptcha.containsKey(key)) {
                _mapStaticCaptcha.put(key, new ArrayList());
            }
            List<ValidableCaptcha> captchas = _mapStaticCaptcha.get(key);
            captchas.add(new ValidableCaptcha(captcha));
        } else if (key.startsWith(DYNAMIC_PREFIX_KEY)) {
            _mapDynamicCaptcha.put(key, vc);
        } else {
            throw new IllegalArgumentException("The key '" + key + "' is not a valid captcha key because it does not starts with '" + DYNAMIC_PREFIX_KEY + "' or '" + STATIC_PREFIX_KEY + "'");
        }
        return vc.getCaptcha().getImage();
    }

    private static Captcha _generateImageCaptcha(Integer color, boolean addNoise, boolean fisheye, int width, int height) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(color));
        ArrayList<Font> fonts = new ArrayList<Font>();
        fonts.add(new Font("Arial", 1, 40));
        fonts.add(new Font("Courier", 1, 40));
        Captcha.Builder builder = new Captcha.Builder(width, height).addText((TextProducer)new DefaultTextProducer(6, "abcdefghijklmnopqrstuvwxyz".toCharArray()), (WordRenderer)new DefaultWordRenderer(colors, fonts)).gimp((GimpyRenderer)new RippleGimpyRenderer()).addNoise((NoiseProducer)new CurvedLineNoiseProducer(new Color(color), 3.0f));
        if (addNoise) {
            builder.addNoise((NoiseProducer)new CurvedLineNoiseProducer(new Color(color), 3.0f)).gimp((GimpyRenderer)new DropShadowGimpyRenderer());
        }
        if (fisheye) {
            builder.gimp((GimpyRenderer)new FishEyeGimpyRenderer());
        }
        return builder.build();
    }

    static {
        _logger = LoggerFactory.getLogger(CaptchaHelper.class);
    }

    static class ValidableCaptcha {
        private Captcha _captcha;
        private Date _date;
        private boolean _valid;

        public ValidableCaptcha(Captcha c) {
            this._captcha = c;
            this._date = new Date();
            this._valid = true;
        }

        public boolean isValid() {
            if (!this._valid) {
                return false;
            }
            GregorianCalendar validity = new GregorianCalendar();
            ((Calendar)validity).add(12, -20);
            return this._date.after(validity.getTime());
        }

        public Captcha getCaptcha() {
            return this._captcha;
        }

        public void invalidate() {
            this._valid = false;
        }
    }

    static enum CaptchaType {
        JCAPTCHA,
        RECAPTCHA;

    }
}

