/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.reading.ResourceReader;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public class RuntimeResourceReader
extends ResourceReader
implements Serviceable {
    public static final String LAST_MODIFIED = "lastModified";
    protected ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    public void setup(org.apache.cocoon.environment.SourceResolver initialResolver, Map cocoonObjectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        SourceResolver runtimeResolver;
        try {
            runtimeResolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
        }
        catch (ServiceException e) {
            String errorMessage = "The runtime resource reader cannot be setup : the runtime source resolver cannot be retrieved";
            this.getLogger().error(errorMessage);
            throw new ProcessingException(errorMessage, (Throwable)e);
        }
        super.setup((org.apache.cocoon.environment.SourceResolver)new SourceResolverWrapper(runtimeResolver), cocoonObjectModel, src, par);
        this.quickTest = true;
        Map params = (Map)this.objectModel.get("parent-context");
        if (params != null) {
            params.put(LAST_MODIFIED, this.getLastModified());
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public void generate() throws IOException, ProcessingException {
        if (!this.inputSource.exists()) {
            throw new ResourceNotFoundException("Resource not found for URI : " + this.inputSource.getURI());
        }
        super.generate();
    }

    class SourceResolverWrapper
    implements org.apache.cocoon.environment.SourceResolver {
        SourceResolver _res;

        public SourceResolverWrapper(SourceResolver res) {
            this._res = res;
        }

        public org.apache.cocoon.environment.Source resolve(String systemID) throws ProcessingException, SAXException, IOException {
            throw new ProcessingException("resolve not handled");
        }

        public void release(Source eSource) {
            this._res.release(eSource);
        }

        public Source resolveURI(String location) throws MalformedURLException, IOException {
            return this._res.resolveURI(location);
        }

        public Source resolveURI(String location, String base, Map sParameters) throws MalformedURLException, IOException {
            return this._res.resolveURI(location, base, sParameters);
        }
    }
}

