/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.serializers.XMLSerializer;
import org.xml.sax.SAXException;

public class XHTMLFragmentSerializer
extends XMLSerializer {
    private static final Set<String> __COLLAPSE_TAGS = new HashSet<String>(Arrays.asList("input", "img", "meta", "link", "hr", "br"));
    private Set<String> _tagsToCollapse;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        String tagsToCollapse = conf.getChild("tags-to-collapse").getValue(null);
        if (tagsToCollapse != null) {
            this._tagsToCollapse = new HashSet<String>();
            for (String tag : tagsToCollapse.split(",")) {
                this._tagsToCollapse.add(tag.trim());
            }
        } else {
            this._tagsToCollapse = __COLLAPSE_TAGS;
        }
    }

    public void endElementImpl(String uri, String local, String qual) throws SAXException {
        if (!this._tagsToCollapse.contains(local)) {
            this.closeElement(false);
        }
        super.endElementImpl(uri, local, qual);
    }
}

