/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.util.HashSet;
import java.util.Set;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class DataSourceConsumerExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<DataSourceConsumer> {
    public static final String ROLE = DataSourceConsumerExtensionPoint.class.getName();

    public boolean isInUse(String id) {
        for (String extensionId : this.getExtensionsIds()) {
            DataSourceConsumer dataSourceClient = (DataSourceConsumer)this.getExtension(extensionId);
            if (!dataSourceClient.isInUse(id)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getUsedDataSourceIds() {
        Set<String> extensionsIds = this.getExtensionsIds();
        HashSet<String> usedDataSourceIds = new HashSet<String>();
        for (String extensionId : extensionsIds) {
            DataSourceConsumer dataSourceClient = (DataSourceConsumer)this.getExtension(extensionId);
            usedDataSourceIds.addAll(dataSourceClient.getUsedDataSourceIds());
        }
        return usedDataSourceIds;
    }
}

