/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class SourceMapCache
extends AbstractLogEnabled
implements Component {
    public static final String ROLE = SourceMapCache.class.getName();
    private static Map<String, SourceMapSource> _sourceMapCache = new HashMap<String, SourceMapSource>();

    public void put(String uri, String content, Long lastModified) {
        SourceMapSource sourceMapData = new SourceMapSource(uri, content, lastModified);
        _sourceMapCache.put(uri, sourceMapData);
    }

    public Source get(String uri) {
        return _sourceMapCache.getOrDefault(uri, null);
    }

    public static final class SourceMapSource
    implements Source {
        private String _content;
        private Long _lastModified;
        private String _location;
        private TimeStampValidity _timeStampValidity;

        public SourceMapSource(String location, String content, Long lastModified) {
            this._location = location;
            this._content = content;
            this._lastModified = lastModified;
        }

        public boolean exists() {
            return true;
        }

        public InputStream getInputStream() throws IOException, SourceNotFoundException {
            return new ByteArrayInputStream(this._content.getBytes(StandardCharsets.UTF_8));
        }

        public String getURI() {
            return this._location;
        }

        public String getScheme() {
            try {
                return new URI(this._location).getScheme();
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        public SourceValidity getValidity() {
            if (this._timeStampValidity == null) {
                this._timeStampValidity = new TimeStampValidity(this._lastModified.longValue());
            }
            return this._timeStampValidity;
        }

        public void refresh() {
        }

        public String getMimeType() {
            return "application/json";
        }

        public long getContentLength() {
            return this._content.length();
        }

        public long getLastModified() {
            return this._lastModified;
        }
    }
}

