/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JSASSFixHelper {
    private static final Pattern SOURCEMAP_SOURCES_PATTERN = Pattern.compile("^([^\"]*\")([^\"]*)(\",?)$", 8);
    private static final String[] JSASS_INJECTED_FILES = new String[]{"JSASS_CUSTOM.scss", "JSASS_PRE_IMPORT.scss", "JSASS_POST_IMPORT.scss"};

    private JSASSFixHelper() {
    }

    public static String fixJsassSourceMap(String sourceMap, String externalContextPath) {
        Matcher matcher = SOURCEMAP_SOURCES_PATTERN.matcher(sourceMap);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String source = matcher.group(2);
            Predicate<String> isJsassInjectedFile = file -> source.endsWith((String)file);
            if (Arrays.stream(JSASS_INJECTED_FILES).anyMatch(isJsassInjectedFile)) {
                matcher.appendReplacement(sb, "$1" + externalContextPath + "/plugins/core/resources/css/jsass_injected_file_placeholder.css$3");
                continue;
            }
            try {
                if (source.startsWith("/") || new URI(source).isAbsolute()) continue;
                matcher.appendReplacement(sb, "$1/$2$3");
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

