/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.minimize.css.MinimizeCSSManager;
import org.ametys.core.resources.AbstractResourceHandler;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class MinimizedCSSResourceHandler
extends AbstractResourceHandler {
    private static final String __ORIGINAL_URI = "original-uri";
    private static final String __MINIMIZED_URI = "minimized-uri";
    protected MinimizeCSSManager _cssMinimizeManager;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._cssMinimizeManager = (MinimizeCSSManager)manager.lookup(MinimizeCSSManager.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    @Override
    public boolean isSupported(String source) {
        return super.isSupported(source);
    }

    @Override
    public int getPriority() {
        return -2147483248;
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        additionalParameters.put(__MINIMIZED_URI, location);
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        if (source != null && source.exists()) {
            return source;
        }
        String sitemapURI = "/" + StringUtils.removeEnd((String)ObjectModelHelper.getRequest((Map)objectModel).getSitemapURI(), (String)".min.css") + ".css";
        source = super.setup("cocoon:" + sitemapURI, objectModel, par, additionalParameters);
        if (!source.exists()) {
            throw new ResourceNotFoundException("Resource not found for URI : '" + location + "'.");
        }
        additionalParameters.put(__ORIGINAL_URI, sitemapURI);
        return source;
    }

    @Override
    public Serializable getKey(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        Serializable key = super.getKey(source, objectModel, parameters, additionalParameters);
        return key + "*" + additionalParameters.getOrDefault(__MINIMIZED_URI, null);
    }

    @Override
    public void generateResource(Source source, OutputStream out, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        String originalUri = additionalParameters.getOrDefault(__ORIGINAL_URI, null);
        if (originalUri == null) {
            this._cssMinimizeManager.validateAndOutputMinimizedFile(source, out, additionalParameters.getOrDefault(__MINIMIZED_URI, null));
            return;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)source.getInputStream(), (OutputStream)bos);
            String code = bos.toString("UTF-8");
            boolean lazyLoadSourceMap = DevMode.DEVMODE.PRODUCTION.equals((Object)DevMode.getDeveloperMode(ObjectModelHelper.getRequest((Map)objectModel)));
            String resolvedOriginalUri = null;
            try {
                resolvedOriginalUri = this._jsassResourceURIExtensionPoint.resolve(originalUri);
            }
            catch (URISyntaxException e) {
                this.getLogger().error("Unable to resolve URI location because URI syntax '" + originalUri + "' is not supported", (Throwable)e);
            }
            String result = resolvedOriginalUri == null || lazyLoadSourceMap ? this._cssMinimizeManager.minimizeCss(code, resolvedOriginalUri) : this._cssMinimizeManager.minimizeCss(code, originalUri, resolvedOriginalUri + ".map", source.getLastModified());
            out.write(result.getBytes(StandardCharsets.UTF_8));
        }
    }
}

