/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css.sass;

import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.ametys.plugins.core.ui.resources.css.CSSFileHelper;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class AmetysScssImporter
implements Importer {
    private SourceResolver _resolver;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;
    private String _internalContextPath;
    private String _externalContextPath;

    public AmetysScssImporter(String internalContextPath, String externalContextPath, SourceResolver resolver, JSASSResourceURIExtensionPoint jsassResourceURIExtensionPoint) {
        this._internalContextPath = internalContextPath;
        this._externalContextPath = externalContextPath;
        this._resolver = resolver;
        this._jsassResourceURIExtensionPoint = jsassResourceURIExtensionPoint;
    }

    public Collection<Import> apply(String url, Import previous) {
        String previousUri = Optional.of(previous).map(Import::getAbsoluteUri).map(URI::toString).filter(uri -> !uri.endsWith(".css")).orElse(null);
        if (previousUri == null || url.endsWith(".css") || url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//")) {
            return null;
        }
        LinkedList<Import> list = new LinkedList<Import>();
        try {
            String importSourceUri;
            String importText;
            boolean isUrlAbsolute = new URI(url).isAbsolute();
            String currentUri = isUrlAbsolute || url.startsWith("/") ? url : StringUtils.removeStart((String)("/" + new URI(FilenameUtils.getFullPath((String)previousUri) + url).normalize()), (String)this._externalContextPath);
            Source importSource = this._getImportSource(currentUri, this._resolver);
            if (importSource.getURI().endsWith(".scss") || importSource.getURI().endsWith(".sass") || importSource.getURI().endsWith(".css") && !currentUri.endsWith(".css")) {
                importText = IOUtils.toString((InputStream)importSource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                importSourceUri = importSource.getURI();
                if (importSourceUri.endsWith(".css")) {
                    String contextualizedUri = isUrlAbsolute ? this._jsassResourceURIExtensionPoint.resolve(url) : url;
                    importText = CSSFileHelper.replaceRelativeUri(importText, contextualizedUri, this._jsassResourceURIExtensionPoint, this._internalContextPath, this._externalContextPath);
                    currentUri = StringUtils.appendIfMissing((String)currentUri, (CharSequence)".css", (CharSequence[])new CharSequence[0]);
                }
            } else {
                return null;
            }
            String uri2 = StringUtils.removeStart((String)StringUtils.prependIfMissing((String)this._jsassResourceURIExtensionPoint.resolve(currentUri), (CharSequence)this._externalContextPath, (CharSequence[])new CharSequence[0]), (String)"/");
            list.add(new Import(uri2, StringUtils.appendIfMissing((String)uri2, (CharSequence)("." + FilenameUtils.getExtension((String)importSourceUri)), (CharSequence[])new CharSequence[0]), importText));
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private Source _getImportSource(String currentPath, SourceResolver resolver) throws URISyntaxException, IOException {
        ArrayList<String> pathMatching = new ArrayList<String>();
        pathMatching.add(currentPath);
        pathMatching.add(currentPath + ".scss");
        pathMatching.add(currentPath + ".sass");
        pathMatching.add(currentPath + ".css");
        String name = FilenameUtils.getName((String)currentPath);
        String partialPath = currentPath.substring(0, currentPath.length() - name.length()) + "_" + name;
        pathMatching.add(partialPath);
        pathMatching.add(partialPath + ".scss");
        pathMatching.add(partialPath + ".sass");
        pathMatching.add(partialPath + ".css");
        for (String uri : pathMatching) {
            try {
                Source importSource = resolver.resolveURI(this._jsassResourceURIExtensionPoint.resolvePath(uri));
                if (!importSource.exists() || importSource instanceof TraversableSource && ((TraversableSource)importSource).isCollection()) continue;
                return importSource;
            }
            catch (SourceNotFoundException sourceNotFoundException) {
            }
        }
        throw new URISyntaxException(currentPath, "Unable to resolve SASS import, no matching source found");
    }
}

