/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.js;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.minimize.AbstractSourceMapResourceHandler;
import org.ametys.core.minimize.js.MinimizeJSManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;

public class JSSourceMapResourceHandler
extends AbstractSourceMapResourceHandler {
    private static final Pattern __LOCALE_PATTERN = Pattern.compile("^(.*resources/.*)\\.([^/.]+)\\.js$");
    protected MinimizeJSManager _jSMinimizeManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jSMinimizeManager = (MinimizeJSManager)manager.lookup(MinimizeJSManager.ROLE);
    }

    @Override
    protected Source _getAlternateSource(String location, Map objectModel) throws ProcessingException, IOException {
        String localizedLocation;
        Source source = null;
        source = location.endsWith(".min.js.map") ? this._getExistingSource(location.substring(0, location.length() - ".min.js.map".length()) + ".js.map") : this._getExistingSource(location.substring(0, location.length() - ".js.map".length()) + ".min.js.map");
        if (source == null && (source = this._sourceMapCache.get(localizedLocation = this._getLocalizedLocation(location))) == null) {
            source = this._generateJSSourceMap(objectModel, localizedLocation);
        }
        return source;
    }

    private String _getLocalizedLocation(String location) {
        String locale;
        Matcher matcher = __LOCALE_PATTERN.matcher(location);
        String string = locale = matcher.matches() ? matcher.group(2) : null;
        if (locale == null) {
            Map objectModel = ContextHelper.getObjectModel((Context)this._context);
            locale = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true).getLanguage();
        }
        return location + (locale != null ? "#" + locale : "");
    }

    private Source _generateJSSourceMap(Map objectModel, String localizedLocation) throws ProcessingException, IOException {
        String originalUri = "cocoon:/" + StringUtils.removeEnd((String)ObjectModelHelper.getRequest((Map)objectModel).getSitemapURI(), (String)".map");
        Source sourceResolved = this._resolver.resolveURI(originalUri);
        if (sourceResolved != null && sourceResolved.exists()) {
            try (InputStream inputStream = sourceResolved.getInputStream();){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
                this._jSMinimizeManager.generateJSSourceMap(baos.toString(StandardCharsets.UTF_8.toString()), originalUri, localizedLocation, sourceResolved.getLastModified());
                Source source = this._sourceMapCache.get(localizedLocation);
                return source;
            }
        }
        return null;
    }
}

