/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.js;

import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.minimize.AbstractMinimizeManager;
import org.ametys.core.minimize.SourceMapCache;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class MinimizeJSManager
extends AbstractMinimizeManager
implements Component {
    public static final String ROLE = MinimizeJSManager.class.getName();
    private static final Pattern __SOURCEMAP_FILE_NAME = Pattern.compile(".*\"file\"\\s*:\\s*\"([^\"]+)\".*", 40);

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceMapCache = (SourceMapCache)manager.lookup(SourceMapCache.ROLE);
    }

    public String minimizeJS(String code, String location) throws ProcessingException, IOException {
        return this.minimizeJS(code, location, null, null);
    }

    public String minimizeJS(String code, String location, String sourceMapKey, Long lastModified) throws IOException, ProcessingException {
        String fileName = location.substring(location.lastIndexOf("/") + 1);
        boolean withSourceMap = sourceMapKey != null && lastModified != null;
        Compiler compiler = this._minimizeJS(code, fileName, withSourceMap);
        String sourceResult = compiler.toSource();
        if (withSourceMap) {
            StringBuilder sb = new StringBuilder();
            compiler.getSourceMap().appendTo((Appendable)sb, fileName);
            this._sourceMapCache.put(sourceMapKey, sb.toString(), lastModified);
            sourceResult = sourceResult + "\n" + this.formatSourceMappingURL(fileName + ".map");
        }
        return sourceResult;
    }

    public String generateJSSourceMap(String code, String location, String sourceMapKey, Long lastModified) throws ProcessingException, IOException {
        String fileName = location.substring(location.lastIndexOf("/") + 1);
        Compiler compiler = this._minimizeJS(code, fileName, true);
        StringBuilder sb = new StringBuilder();
        compiler.toSource();
        compiler.getSourceMap().appendTo((Appendable)sb, fileName);
        String sourceMap = sb.toString();
        this._sourceMapCache.put(sourceMapKey, sourceMap, lastModified);
        return sourceMap;
    }

    private Compiler _minimizeJS(String code, String fileName, boolean withSourceMap) throws ProcessingException {
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        options.setTracerMode(CompilerOptions.TracerMode.OFF);
        WarningLevel.QUIET.setOptionsForWarningLevel(options);
        if (withSourceMap) {
            options.setSourceMapOutputPath("unused");
        }
        options.setEmitUseStrict(false);
        options.setOutputCharset(StandardCharsets.UTF_8);
        CompilationLevel level = CompilationLevel.WHITESPACE_ONLY;
        level.setOptionsForCompilationLevel(options);
        SourceFile file = SourceFile.fromCode((String)fileName, (String)code);
        Result result = compiler.compile(Collections.emptyList(), Arrays.asList(file), options);
        if (result.errors.length > 0) {
            StringBuilder errorsString = new StringBuilder();
            errorsString.append("Error: unable to minimize " + fileName);
            for (JSError error : result.errors) {
                errorsString.append("\n" + error.toString());
            }
            throw new ProcessingException(errorsString.toString());
        }
        return compiler;
    }

    @Override
    protected void addSourceMap(SourceMapGeneratorV3 sourceMapGenerator, int lineCount, String fileContent, String fileUri, String sourceMapUri) {
        block18: {
            try {
                String sourceMapContent;
                String sourceMapCacheKey = fileUri.indexOf(47) > -1 ? fileUri.substring(0, fileUri.lastIndexOf("/") + 1) + sourceMapUri : sourceMapUri;
                Source mapSource = this._sourceMapCache.get(sourceMapCacheKey);
                if (mapSource == null) {
                    String uriToResolve = new URI(sourceMapCacheKey).isAbsolute() ? sourceMapCacheKey : "cocoon:/" + sourceMapCacheKey;
                    try {
                        mapSource = this._resolver.resolveURI(uriToResolve);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (mapSource == null || !mapSource.exists()) break block18;
                try (InputStream is = mapSource.getInputStream();){
                    sourceMapContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                Matcher fileMatcher = __SOURCEMAP_FILE_NAME.matcher(sourceMapContent);
                if (fileMatcher.matches()) {
                    sourceMapContent = sourceMapContent.replaceFirst("\"file\":\"" + fileMatcher.group(1) + "\"", "\"file\":\"" + this._proxiedContextPathProvider.getContextPath() + fileUri + "\"");
                }
                sourceMapContent = super.convertSourceMapURIs(sourceMapContent, fileUri);
                sourceMapGenerator.mergeMapSection(lineCount + 1, 0, sourceMapContent);
            }
            catch (SourceMapParseException | IOException | IllegalStateException | URISyntaxException e) {
                this.getLogger().error("Unable to retrieve source map when aggregating hash file, for sourceMappingURL '" + sourceMapUri + "' of file '" + fileUri + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected String getUriMinimizedContent(String uri, String media, String nestedParentFilesName) {
        Source jssource;
        StringBuffer sb;
        block21: {
            sb = new StringBuffer();
            sb.append("/** File : " + uri + " */\n");
            jssource = null;
            try {
                String s;
                URI uriToResolve = new URI(uri);
                if (!uriToResolve.isAbsolute()) {
                    uriToResolve = new URI("cocoon:/" + uri);
                }
                jssource = this._resolver.resolveURI(uriToResolve.normalize().toString());
                try (InputStream is = jssource.getInputStream();){
                    s = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                if (!StringUtils.endsWith((CharSequence)uri, (CharSequence)".min.js")) {
                    sb.append(this.minimizeJS(s.toString(), uri, uri + ".map", jssource.getLastModified()));
                    break block21;
                }
                sb.append(s);
            }
            catch (SourceException e) {
                block22: {
                    this.getLogger().error("Cannot minimize JS for file '" + uri + "'.", (Throwable)e);
                    Throwable cause = e.getCause();
                    if (cause == null) break block22;
                    sb.append("console.error('" + StringEscapeUtils.escapeJavaScript((String)cause.getMessage()) + "');");
                }
                this._resolver.release(jssource);
            }
            catch (Exception e2) {
                this.getLogger().error("Cannot minimize JS for file '" + uri + "'.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        this._resolver.release(jssource);
                        throw throwable;
                    }
                }
                this._resolver.release(jssource);
            }
        }
        this._resolver.release(jssource);
        sb.append("\n");
        return sb.toString();
    }

    @Override
    protected boolean isSourceMappingURLLine(String line) {
        return line != null && line.startsWith("//# sourceMappingURL=");
    }

    @Override
    protected String getSourceMappingURL(String line) {
        return line.substring("//# sourceMappingURL=".length()).trim();
    }

    @Override
    protected String removeSourceMappingURLLine(String content) {
        return content.substring(0, content.lastIndexOf("//# sourceMappingURL="));
    }

    @Override
    protected String formatSourceMappingURL(String sourceMapName) {
        return "//# sourceMappingURL=" + sourceMapName + "\n";
    }
}

