/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.js;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.minimize.js.MinimizeJSManager;
import org.ametys.core.resources.JSResourceHandler;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class MinimizedJSResourceHandler
extends JSResourceHandler {
    private static final String __REAL_FILE_URI = "real-file-uri";
    private static final String __FILE_LOCATION = "file-location";
    protected MinimizeJSManager _jSMinimizeManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jSMinimizeManager = (MinimizeJSManager)manager.lookup(MinimizeJSManager.ROLE);
    }

    @Override
    public int getPriority() {
        return -2147483048;
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        String realLocation;
        additionalParameters.put(__FILE_LOCATION, location);
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        if (source != null && source.exists()) {
            return source;
        }
        if (location.endsWith(".min.js")) {
            realLocation = location.substring(0, location.length() - ".min.js".length()) + ".js";
            source = super.setup(realLocation, objectModel, par, additionalParameters);
            if (!source.exists()) {
                throw new ResourceNotFoundException("Resource not found for URI : '" + location + "'.");
            }
        } else {
            throw new ResourceNotFoundException("Resource not found for URI : '" + location + "'.");
        }
        additionalParameters.put(__REAL_FILE_URI, realLocation);
        return source;
    }

    @Override
    public Serializable getKey(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        Serializable key = super.getKey(source, objectModel, parameters, additionalParameters);
        return key + "*" + additionalParameters.getOrDefault(__FILE_LOCATION, null);
    }

    @Override
    public void generateResource(Source source, OutputStream out, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        String realFileUri = additionalParameters.getOrDefault(__REAL_FILE_URI, null);
        if (realFileUri == null) {
            this._jSMinimizeManager.validateAndOutputMinimizedFile(source, out, additionalParameters.getOrDefault(__FILE_LOCATION, null));
            return;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            additionalParameters.put("parameter-enable-expire-header", "false");
            super.generateResource(source, bos, objectModel, par, additionalParameters);
            String code = bos.toString("UTF-8");
            String locale = this.getLocale(additionalParameters);
            boolean lazyLoadSourceMap = DevMode.DEVMODE.PRODUCTION.equals((Object)DevMode.getDeveloperMode(ObjectModelHelper.getRequest((Map)objectModel)));
            String result = lazyLoadSourceMap ? this._jSMinimizeManager.minimizeJS(code, realFileUri) : this._jSMinimizeManager.minimizeJS(code, realFileUri, realFileUri + ".map" + (locale != null ? "#" + locale : ""), source.getLastModified());
            out.write(result.getBytes(StandardCharsets.UTF_8));
        }
    }
}

