/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Locale;
import org.ametys.runtime.model.type.ElementType;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractElementType<T>
implements ElementType<T> {
    private String _id;
    private Class _type;
    private Class _typeArray;

    public AbstractElementType() {
        Class<?> c = this.getClass();
        while (!c.getSuperclass().equals(AbstractElementType.class)) {
            c = c.getSuperclass();
        }
        this._type = (Class)((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()[0];
        try {
            this._typeArray = Class.forName("[L" + this._type.getName() + ";");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible to find class '" + this._type.getName() + "' in an implementation of AbstractElementType", e);
        }
    }

    @Override
    public Class getManagedClass() {
        return this._type;
    }

    @Override
    public Class getManagedClassArray() {
        return this._typeArray;
    }

    @Override
    public String toString(T value) {
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected void _saxValue(ContentHandler contentHandler, String tagName, T value, Locale locale) throws SAXException {
        XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (String)this.toString(value));
    }

    @Override
    public T parseConfiguration(Configuration configuration) throws ConfigurationException {
        String value = null;
        if (configuration != null) {
            value = configuration.getValue(null);
        }
        return this.castValue(value);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void saxValue(ContentHandler contentHandler, String tagName, Object value, Locale locale) throws SAXException {
        if (value != null) {
            if (this.getManagedClass().isInstance(value)) {
                this._saxValue(contentHandler, tagName, value, locale);
            } else if (this.getManagedClassArray().isInstance(value)) {
                for (Object singleValue : (Object[])value) {
                    this._saxValue(contentHandler, tagName, singleValue, locale);
                }
            } else {
                throw new IllegalArgumentException("Try to sax the non " + this.getManagedClass().getName() + " value '" + value + "' in tag name '" + tagName + "'");
            }
        }
    }

    @Override
    public Object valueToJSONForClient(Object value) {
        if (value == null || this.getManagedClass().isInstance(value)) {
            return value;
        }
        if (this.getManagedClassArray().isInstance(value)) {
            return Arrays.asList((Object[])value);
        }
        throw new IllegalArgumentException("Try to convert the non " + this.getManagedClass().getName() + " value '" + value + "' to JSON");
    }
}

