/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public abstract class AbstractResourceHandler
extends AbstractLogEnabled
implements ResourceHandler,
Serviceable,
Configurable,
Contextualizable {
    protected Set<String> _supportedSuffixes;
    protected SourceResolver _resolver;
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] suffixConf;
        this._supportedSuffixes = new HashSet<String>();
        for (Configuration suffix : suffixConf = configuration.getChild("suffixes").getChildren("suffix")) {
            this._supportedSuffixes.add(StringUtils.lowerCase((String)suffix.getValue()));
        }
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        Source src = this._resolver.resolveURI(location);
        if (!src.exists()) {
            throw new ResourceNotFoundException("Resource not found for URI : " + src.getURI());
        }
        return src;
    }

    @Override
    public boolean isSupported(String source) {
        String lcSource = StringUtils.lowerCase((String)source);
        for (String supportedSuffix : this._supportedSuffixes) {
            if (!StringUtils.endsWith((CharSequence)lcSource, (CharSequence)supportedSuffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return -2147483148;
    }

    @Override
    public String getMimeType(Source source, Parameters parameters) {
        String mimeType;
        if (this._cocoonContext != null && (mimeType = this._cocoonContext.getMimeType(source.getURI())) != null) {
            return mimeType;
        }
        return source.getMimeType();
    }

    @Override
    public Serializable getKey(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        return source.getURI();
    }

    @Override
    public SourceValidity getValidity(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        return source.getValidity();
    }

    @Override
    public long getSize(Source source, Parameters parameters) {
        return source.getContentLength();
    }

    @Override
    public long getLastModified(Source source, Parameters parameters) {
        return source.getLastModified();
    }
}

