/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Right {
    private final String _id;
    private final I18nizableText _label;
    private final I18nizableText _description;
    private final I18nizableText _category;
    private final String _declaration;

    Right(String id, I18nizableText label, I18nizableText description, I18nizableText category, String declaration) {
        this._id = id;
        this._label = label;
        this._description = description;
        this._category = category;
        this._declaration = declaration;
    }

    public String getId() {
        return this._id;
    }

    public I18nizableText getLabel() {
        return this._label;
    }

    public I18nizableText getDescription() {
        return this._description;
    }

    public I18nizableText getCategory() {
        return this._category;
    }

    public String getDeclaration() {
        return this._declaration;
    }

    public void toSAX(ContentHandler ch) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", this._id);
        XMLUtils.startElement((ContentHandler)ch, (String)"right", (Attributes)atts);
        this._label.toSAX(ch, "label");
        this._description.toSAX(ch, "description");
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", this._category.toString().replaceAll("[^a-zA-Z0-9]", "_"));
        XMLUtils.startElement((ContentHandler)ch, (String)"category", (Attributes)attrs);
        this._category.toSAX(ch);
        XMLUtils.endElement((ContentHandler)ch, (String)"category");
        XMLUtils.endElement((ContentHandler)ch, (String)"right");
    }

    public Map<String, Object> toJSON() {
        HashMap<String, Object> right = new HashMap<String, Object>();
        right.put("id", this._id);
        right.put("label", this._label);
        right.put("description", this._description);
        right.put("category", this._category);
        return right;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Right)) {
            return false;
        }
        return this._id.equals(((Right)object).getId());
    }
}

