/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.schedule;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.engine.BackgroundEngineHelper;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.SchedulableExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.core.user.UserDAO;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.background.BackgroundEnvironment;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class AmetysJob
implements Job {
    public static final String KEY_LAST_DURATION = "duration";
    public static final String KEY_PREVIOUS_FIRE_TIME = "previousFireTime";
    public static final String KEY_SUCCESS = "success";
    protected static ServiceManager _serviceManager;
    protected static SchedulableExtensionPoint _schedulableEP;
    protected static Scheduler _scheduler;
    protected static Context _environmentContext;
    protected static UserManager _userManager;

    public static void initialize(ServiceManager serviceManager, org.apache.avalon.framework.context.Context context) throws ServiceException, ContextException {
        _serviceManager = serviceManager;
        _schedulableEP = (SchedulableExtensionPoint)serviceManager.lookup(SchedulableExtensionPoint.ROLE);
        _scheduler = (Scheduler)serviceManager.lookup(Scheduler.ROLE);
        _environmentContext = (Context)context.get((Object)"environment-context");
        _userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
    }

    public static void dispose() {
        _serviceManager = null;
        _schedulableEP = null;
        _scheduler = null;
        _environmentContext = null;
        _userManager = null;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail detail = context.getJobDetail();
        JobDataMap jobDataMap = detail.getJobDataMap();
        JobKey jobKey = detail.getKey();
        String runnableId = jobDataMap.getString("id");
        String schedulableId = jobDataMap.getString("schedulableId");
        Schedulable schedulable = (Schedulable)_schedulableEP.getExtension(schedulableId);
        Logger logger = LoggerFactory.getLogger((String)(AmetysJob.class.getName() + "$" + schedulableId));
        if (!schedulable.acceptConcurrentExecution() && this._checkConcurrency(schedulableId, runnableId, jobKey, logger)) {
            logger.warn("The Runnable '{}' of the Schedulable '{}' cannot be executed now because concurrent execution is not allowed for this Schedulable", (Object)runnableId, (Object)schedulableId);
            return;
        }
        boolean success = true;
        jobDataMap.put(KEY_PREVIOUS_FIRE_TIME, context.getTrigger().getPreviousFireTime().getTime());
        Map<String, Object> environmentInformation = BackgroundEngineHelper.createAndEnterEngineEnvironment(_serviceManager, _environmentContext, (org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(logger));
        String userIdentityAsString = jobDataMap.getString("userIdentity");
        if (!this._setUserInSession(environmentInformation, userIdentityAsString)) {
            success = false;
            String message = String.format("The UserIdentity '%s' defined for the execution of the job '%s' is not valid", userIdentityAsString, schedulableId);
            logger.error(message);
            throw new JobExecutionException(message);
        }
        logger.info("Executing the Runnable '{}' of the Schedulable '{}' with jobDataMap:\n '{}'", new Object[]{runnableId, schedulableId, jobDataMap.getWrappedMap().toString()});
        Instant start = Instant.now();
        try {
            schedulable.execute(context);
        }
        catch (Exception e) {
            success = false;
            logger.error(String.format("An exception occured during the execution of the Schedulable '%s'", schedulableId), (Throwable)e);
            throw new JobExecutionException(String.format("An exception occured during the execution of the job '%s'", schedulableId), (Throwable)e);
        }
        catch (Throwable t) {
            success = false;
            logger.error(String.format("An error occured during the execution of the Schedulable '%s'", schedulableId), t);
            throw t;
        }
        finally {
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            jobDataMap.put(KEY_LAST_DURATION, duration);
            if (environmentInformation != null) {
                BackgroundEngineHelper.leaveEngineEnvironment(environmentInformation);
            }
            jobDataMap.put(KEY_SUCCESS, success);
            if (Runnable.FireProcess.STARTUP.toString().equals(jobDataMap.getString("fireProcess"))) {
                jobDataMap.put("runAtStartupCompleted", true);
            }
        }
    }

    private boolean _setUserInSession(Map<String, Object> environmentInformation, String userIdentityAsString) {
        UserIdentity userIdentity = Optional.ofNullable(userIdentityAsString).map(UserIdentity::stringToUserIdentity).orElse(UserPopulationDAO.SYSTEM_USER_IDENTITY);
        if (_userManager.getUser(userIdentity) == null) {
            return false;
        }
        BackgroundEnvironment bgEnv = (BackgroundEnvironment)environmentInformation.get("environment");
        Request request = ObjectModelHelper.getRequest((Map)bgEnv.getObjectModel());
        AuthenticateAction.setUserIdentityInSession(request, userIdentity, new UserDAO.ImpersonateCredentialProvider(), true);
        return true;
    }

    private boolean _checkConcurrency(String schedulableId, String runnableId, JobKey currentJobKey, Logger logger) throws JobExecutionException {
        try {
            return _scheduler.getScheduler().getCurrentlyExecutingJobs().stream().map(JobExecutionContext::getJobDetail).filter(detail -> !detail.getKey().equals((Object)currentJobKey)).map(detail -> detail.getJobDataMap().getString("schedulableId")).filter(id -> id.equals(schedulableId)).findFirst().isPresent();
        }
        catch (SchedulerException e) {
            logger.error(String.format("An error occured during the concurrency check of the Runnable '%s'", runnableId), (Throwable)e);
            throw new JobExecutionException(String.format("An error occured during the concurrency check of the Runnable '%s'", runnableId), (Throwable)e);
        }
    }
}

