/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideElementDependenciesManager;
import org.ametys.core.ui.MenuClientSideElement;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.core.ui.RibbonImport;
import org.ametys.core.ui.RibbonImportManager;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.RibbonManagerCache;
import org.ametys.core.ui.RibbonTabsManager;
import org.ametys.core.ui.SAXClientSideElementHelper;
import org.ametys.core.ui.ribbonconfiguration.ControlRef;
import org.ametys.core.ui.ribbonconfiguration.Element;
import org.ametys.core.ui.ribbonconfiguration.Group;
import org.ametys.core.ui.ribbonconfiguration.GroupSize;
import org.ametys.core.ui.ribbonconfiguration.Layout;
import org.ametys.core.ui.ribbonconfiguration.RibbonConfiguration;
import org.ametys.core.ui.ribbonconfiguration.RibbonExclude;
import org.ametys.core.ui.ribbonconfiguration.RibbonMenu;
import org.ametys.core.ui.ribbonconfiguration.Separator;
import org.ametys.core.ui.ribbonconfiguration.Tab;
import org.ametys.core.ui.ribbonconfiguration.Toolbar;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RibbonConfigurationManager {
    private static Logger _logger = LoggerFactory.getLogger(RibbonConfigurationManager.class);
    private static Pattern _PLUGINNAMEPATTERN = Pattern.compile("^plugin:([^:]+)://.*$");
    protected RibbonManager _ribbonManager;
    protected RibbonTabsManager _ribbonTabManager;
    protected SAXClientSideElementHelper _saxClientSideElementHelper;
    protected SourceResolver _resolver;
    protected RibbonConfiguration _ribbonConfig;
    protected Set<String> _controlsReferences = new HashSet<String>();
    protected Set<String> _tabsReferences = new HashSet<String>();
    protected RibbonControlsManager _ribbonControlManager;
    protected RibbonImportManager _ribbonImportManager;
    private boolean _initialized;

    public RibbonConfigurationManager(RibbonControlsManager ribbonControlManager, RibbonManager ribbonManager, RibbonTabsManager ribbonTabManager, RibbonImportManager ribbonImportManager, SAXClientSideElementHelper saxClientSideElementHelper, SourceResolver resolver, ClientSideElementDependenciesManager dependenciesManager, RibbonManagerCache ribbonManagerCache, Source config, String workspaceName) {
        this._ribbonControlManager = ribbonControlManager;
        this._ribbonManager = ribbonManager;
        this._ribbonTabManager = ribbonTabManager;
        this._ribbonImportManager = ribbonImportManager;
        this._saxClientSideElementHelper = saxClientSideElementHelper;
        this._resolver = resolver;
        try {
            this._configure(config, dependenciesManager, ribbonManagerCache, workspaceName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read the configuration file", e);
        }
        for (Map.Entry<String, List<String>> entry : this._ribbonConfig.getDependencies().entrySet()) {
            String extensionPoint = entry.getKey();
            for (String extensionId : entry.getValue()) {
                dependenciesManager.register(extensionPoint, extensionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _configure(Source config, ClientSideElementDependenciesManager dependenciesManager, RibbonManagerCache ribbonManagerCache, String workspaceName) throws Exception {
        RibbonManager ribbonManager = this._ribbonManager;
        synchronized (ribbonManager) {
            this._ribbonConfig = ribbonManagerCache.getCachedConfiguration(this._ribbonManager);
            if (this._ribbonConfig != null) {
                return;
            }
            this._ribbonConfig = new RibbonConfiguration();
            Object configuration = config.exists() ? new DefaultConfigurationBuilder().build(config.getInputStream()) : new DefaultConfiguration("ribbon");
            HashMap<String, Long> importsValidity = new HashMap<String, Long>();
            importsValidity.put(config.getURI(), config.getLastModified());
            HashMap<String, Map<String, Object>> imports = new HashMap<String, Map<String, Object>>();
            HashMap<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>> excluded = new HashMap<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>>();
            for (RibbonExclude.EXCLUDETYPE excludetype : RibbonExclude.EXCLUDETYPE.values()) {
                excluded.put(excludetype, new ArrayList());
            }
            this._configureExcluded((Configuration)configuration, imports, excluded, workspaceName);
            this._configureRibbon((Configuration)configuration, dependenciesManager, imports, importsValidity, excluded, null);
            for (Map.Entry entry2 : imports.entrySet()) {
                if (!"automatic".equals(((Map)entry2.getValue()).get("type"))) continue;
                this._configureImport(dependenciesManager, importsValidity, (String)entry2.getKey(), imports, excluded);
            }
            Map<String, Tab> tabsLabelMapping = this._ribbonConfig.getTabs().stream().filter(tab -> !tab.isOverride()).collect(Collectors.toMap(Tab::getLabel, Function.identity(), (tab1, tab2) -> tab1));
            this._configureTabOverride(tabsLabelMapping);
            List<String> list = excluded.entrySet().stream().filter(entry -> RibbonExclude.EXCLUDETYPE.CONTROL.equals(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).filter(exclude -> RibbonExclude.EXCLUDETARGET.ID.equals((Object)exclude.getTarget())).map(RibbonExclude::getValue).collect(Collectors.toList());
            for (Tab tab3 : this._ribbonConfig.getTabs()) {
                this._removeExcludedControls(tab3, list);
            }
            this._configureTabOrder(tabsLabelMapping);
            ribbonManagerCache.addCachedConfiguration(this._ribbonManager, this._ribbonConfig, importsValidity);
            this._ribbonManager.initializeExtensions();
        }
    }

    private void _configureExcluded(Configuration configuration, Map<String, Map<String, Object>> imports, Map<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>> excluded, String workspaceName) throws ConfigurationException {
        this._configureExcludeFromImports(configuration, imports, excluded);
        for (String extensionId : this._ribbonImportManager.getExtensionsIds()) {
            RibbonImport ribbonImportExtension = (RibbonImport)this._ribbonImportManager.getExtension(extensionId);
            if (ribbonImportExtension == null) continue;
            for (Map.Entry<List<String>, Pattern> importFiles : ribbonImportExtension.getImports().entrySet()) {
                if (!importFiles.getValue().matcher(workspaceName).matches()) continue;
                for (String importUri : importFiles.getKey()) {
                    this._configureExcludeFromImports(importUri, imports, excluded);
                    Map<String, Object> properties = imports.get(importUri);
                    if (properties == null) continue;
                    properties.put("extension", extensionId);
                    properties.put("type", "automatic");
                }
            }
        }
    }

    private void _configureExcludeFromImports(String url, Map<String, Map<String, Object>> imports, Map<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>> excluded) throws ConfigurationException {
        if (!imports.containsKey(url)) {
            Source src = null;
            try {
                src = this._resolver.resolveURI(url);
                if (!src.exists()) {
                    throw new SourceNotFoundException(url + " does not exists");
                }
                try (InputStream is = src.getInputStream();){
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("RibbonConfigurationManager : new file imported '" + url + "'");
                    }
                    Configuration importedConfiguration = new DefaultConfigurationBuilder().build(is);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("configuration", importedConfiguration);
                    properties.put("lastModified", src.getLastModified());
                    imports.put(url, properties);
                    this._configureExcludeFromImports(importedConfiguration, imports, excluded);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot import file " + url, (Throwable)e);
            }
            finally {
                this._resolver.release(src);
            }
        }
    }

    private void _configureExcludeFromImports(Configuration configuration, Map<String, Map<String, Object>> imports, Map<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>> excluded) throws ConfigurationException {
        for (Configuration excludeConf : configuration.getChild("exclude").getChildren()) {
            RibbonExclude ribbonExclude = new RibbonExclude(excludeConf, _logger);
            excluded.get((Object)ribbonExclude.getType()).add(ribbonExclude);
        }
        for (Configuration importConfig : configuration.getChild("tabs").getChildren("import")) {
            String url = importConfig.getValue();
            this._configureExcludeFromImports(url, imports, excluded);
        }
    }

    private void _configureRibbon(Configuration configuration, ClientSideElementDependenciesManager dependenciesManager, Map<String, Map<String, Object>> imports, Map<String, Long> importValidity, Map<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>> excludedList, String url) throws ConfigurationException {
        Configuration[] dependenciesConfigurations;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Starting reading ribbon configuration");
        }
        for (Configuration appMenuConfig : configuration.getChildren("app-menu")) {
            this._configureRibbonMenu(appMenuConfig, this._ribbonConfig.getAppMenu(), excludedList.get((Object)RibbonExclude.EXCLUDETYPE.APPMENU), url != null ? imports.get(url) : null, url);
        }
        for (Configuration userMenuConfig : configuration.getChildren("user-menu")) {
            this._configureRibbonMenu(userMenuConfig, this._ribbonConfig.getUserMenu(), excludedList.get((Object)RibbonExclude.EXCLUDETYPE.USERMENU), url != null ? imports.get(url) : null, url);
        }
        for (Configuration dependencyConfigurations : dependenciesConfigurations = configuration.getChild("depends").getChildren()) {
            String extensionPoint = dependencyConfigurations.getName();
            String extensionId = dependencyConfigurations.getValue();
            this._ribbonConfig.addDependency(extensionPoint, extensionId);
        }
        Configuration[] tabsConfigurations = configuration.getChild("tabs").getChildren();
        Integer defaultOrder = url != null ? Integer.MAX_VALUE : 0;
        for (Configuration tabConfiguration : tabsConfigurations) {
            if ("tab".equals(tabConfiguration.getName())) {
                Tab tab = new Tab(tabConfiguration, this._ribbonManager, defaultOrder, _logger);
                if (url == null || !this._isTabExcluded(tab, excludedList)) {
                    this._ribbonConfig.getTabs().add(tab);
                }
                defaultOrder = null;
                continue;
            }
            if (!"import".equals(tabConfiguration.getName())) continue;
            String importUrl = tabConfiguration.getValue();
            this._configureImport(dependenciesManager, importValidity, importUrl, imports, excludedList);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Ending reading ribbon configuration");
        }
    }

    private void _configureRibbonMenu(Configuration configuration, RibbonMenu ribbonMenu, List<RibbonExclude> excludedList, Map<String, Object> properties, String url) throws ConfigurationException {
        if (url != null && this._isFileExcluded(properties, excludedList, url)) {
            return;
        }
        List excludedControls = excludedList.stream().filter(exclude -> RibbonExclude.EXCLUDETARGET.ID.equals((Object)exclude.getTarget())).map(RibbonExclude::getValue).collect(Collectors.toList());
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Configuration childConfig : configuration.getChildren()) {
            if ("control".equals(childConfig.getName())) {
                if (excludedControls.contains(childConfig.getAttribute("id", null))) continue;
                elements.add(new ControlRef(childConfig, this._ribbonManager, _logger));
                continue;
            }
            if ("separator".equals(childConfig.getName())) {
                elements.add(new Separator());
                continue;
            }
            _logger.warn("During configuration of the ribbon, the app-menu or user-menu use an unknow tag '" + configuration.getName() + "'");
        }
        ribbonMenu.addElements(elements, configuration.getAttribute("order", "0.10"), _logger);
    }

    private void _configureImport(ClientSideElementDependenciesManager dependenciesManager, Map<String, Long> importValidity, String url, Map<String, Map<String, Object>> imports, Map<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>> excludedList) throws ConfigurationException {
        if (!imports.containsKey(url)) {
            return;
        }
        if (importValidity.containsKey(url) || this._isFileExcluded(imports.get(url), excludedList.get((Object)RibbonExclude.EXCLUDETYPE.IMPORT), url)) {
            return;
        }
        Map<String, Object> properties = imports.get(url);
        if (properties.containsKey("configuration")) {
            Configuration configuration = (Configuration)properties.get("configuration");
            importValidity.put(url, (long)((Long)properties.get("lastModified")));
            this._configureRibbon(configuration, dependenciesManager, imports, importValidity, excludedList, url);
        }
    }

    private boolean _isFileExcluded(Map<String, Object> properties, List<RibbonExclude> excludedList, String url) {
        Matcher matcher = _PLUGINNAMEPATTERN.matcher(url);
        String pluginName = matcher.matches() ? matcher.group(1) : null;
        for (RibbonExclude ribbonExclude : excludedList) {
            if (RibbonExclude.EXCLUDETARGET.EXTENSION.equals((Object)ribbonExclude.getTarget()) && properties.containsKey("extension") && ribbonExclude.getValue().equals(properties.get("extension"))) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("RibbonConfigurationManager : The import '" + url + "' was not resolved because its extension '" + properties.get("extension") + "' is excluded.");
                }
                return true;
            }
            if (RibbonExclude.EXCLUDETARGET.PLUGIN.equals((Object)ribbonExclude.getTarget()) && pluginName != null && ribbonExclude.getValue().equals(pluginName)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("RibbonConfigurationManager : The import '" + url + "' was not resolved because its plugin '" + pluginName + "' is excluded.");
                }
                return true;
            }
            if (!RibbonExclude.EXCLUDETARGET.FILE.equals((Object)ribbonExclude.getTarget()) || !ribbonExclude.getValue().equals(url)) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug("RibbonConfigurationManager : The import '" + url + "' was not resolved because the file url is excluded.");
            }
            return true;
        }
        return false;
    }

    private boolean _isTabExcluded(Tab tab, Map<RibbonExclude.EXCLUDETYPE, List<RibbonExclude>> excludedList) {
        String tabLabel = tab.getLabel();
        for (RibbonExclude ribbonExclude : excludedList.get((Object)RibbonExclude.EXCLUDETYPE.TAB)) {
            if (!RibbonExclude.EXCLUDETARGET.LABEL.equals((Object)ribbonExclude.getTarget()) || !ribbonExclude.getValue().equals(tabLabel)) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug("RibbonConfigurationManager : The tab '" + tabLabel + "' was not added because it is excluded.");
            }
            return true;
        }
        return tab.getGroups().size() == 0;
    }

    private void _removeExcludedControls(Tab tab, List<String> excludedList) {
        for (Group group : tab.getGroups()) {
            GroupSize smallGroupSize;
            GroupSize mediumGroupSize;
            GroupSize largeGroupSize = group.getLargeGroupSize();
            if (largeGroupSize != null) {
                this._removeExcludedControls(largeGroupSize.getChildren(), excludedList);
            }
            if ((mediumGroupSize = group.getMediumGroupSize()) != null) {
                this._removeExcludedControls(mediumGroupSize.getChildren(), excludedList);
            }
            if ((smallGroupSize = group.getSmallGroupSize()) == null) continue;
            this._removeExcludedControls(smallGroupSize.getChildren(), excludedList);
        }
    }

    private void _removeExcludedControls(List<Element> elements, List<String> excludedList) {
        ArrayList<Element> elementsToRemove = new ArrayList<Element>();
        for (Element element : elements) {
            if (element instanceof ControlRef) {
                ControlRef control = (ControlRef)element;
                if (!excludedList.contains(control.getId())) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("RibbonConfigurationManager : The control '" + control.getId() + "' was not added because it is excluded.");
                }
                elementsToRemove.add(element);
                continue;
            }
            this._removeExcludedControls(element.getChildren(), excludedList);
            if (element.getChildren().size() != 0) continue;
            elementsToRemove.add(element);
        }
        elements.removeAll(elementsToRemove);
    }

    private void _configureTabOverride(Map<String, Tab> labelMapping) {
        List tabsOverride = this._ribbonConfig.getTabs().stream().filter(Tab::isOverride).collect(Collectors.toList());
        for (Tab tab : tabsOverride) {
            if (!labelMapping.containsKey(tab.getLabel())) continue;
            labelMapping.get(tab.getLabel()).injectGroups(tab.getGroups());
        }
        for (Tab tab : tabsOverride) {
            if (!labelMapping.containsKey(tab.getLabel())) continue;
            labelMapping.get(tab.getLabel()).injectGroupsOverride(tab.getGroups());
        }
        this._ribbonConfig.getTabs().removeAll(tabsOverride);
    }

    private void _configureTabOrder(Map<String, Tab> labelMapping) {
        LinkedList<Tab> tabs = this._ribbonConfig.getTabs();
        Collections.sort(tabs, (tab1, tab2) -> tab1.isContextual() != tab2.isContextual() ? (tab1.isContextual().booleanValue() ? 1 : -1) : 0);
        List tabsToMove = tabs.stream().filter(tab -> tab.getOrderAsString() != null).collect(Collectors.toList());
        for (Tab tab3 : tabsToMove) {
            Tab referencedTab;
            String order = tab3.getOrderAsString();
            Tab tab4 = referencedTab = order != null ? labelMapping.get(order) : null;
            if (order != null && referencedTab != null && referencedTab != tab3 && referencedTab.isContextual() == tab3.isContextual()) {
                tabs.remove(tab3);
                int index = tabs.indexOf(referencedTab);
                tabs.add(tab3.orderBefore() ? index : index + 1, tab3);
                tab3.setOrder(null);
                continue;
            }
            _logger.warn("Invalid tab attribute order with value '" + order + "' for tab '" + tab3.getId() + "'. Default tab order will be used instead");
        }
        Integer previousOrder = null;
        for (Tab tab5 : tabs) {
            Integer tabOrder = tab5.getOrderAsInteger();
            if (tabOrder == null) {
                tab5.setOrder(previousOrder);
                continue;
            }
            previousOrder = tabOrder;
        }
        Collections.sort(tabs, (tab1, tab2) -> tab1.isContextual() == tab2.isContextual() ? tab1.getOrderAsInteger() - tab2.getOrderAsInteger() : 0);
    }

    private synchronized void _lazyInitialize() {
        if (this._initialized) {
            return;
        }
        for (Tab tab : this._ribbonConfig.getTabs()) {
            if (tab.getId() != null) {
                Object tabElement = this._ribbonTabManager.getExtension(tab.getId());
                if (tabElement == null) {
                    String errorMessage = "A tab item referes an unexisting item factory with id '" + tab.getId() + "'";
                    _logger.error(errorMessage);
                    throw new IllegalStateException(errorMessage);
                }
                this._tabsReferences.add(tab.getId());
            }
            for (Group group : tab.getGroups()) {
                this._lazyInitialize(group.getLargeGroupSize());
                this._lazyInitialize(group.getMediumGroupSize());
                this._lazyInitialize(group.getSmallGroupSize());
            }
        }
        this._lazyInitialize(this._ribbonConfig.getAppMenu().getElements());
        this._lazyInitialize(this._ribbonConfig.getUserMenu().getElements());
        this._initialized = true;
    }

    private void _lazyInitialize(GroupSize groupSize) {
        if (groupSize != null) {
            this._lazyInitialize(groupSize.getChildren());
            for (Element element : groupSize.getChildren()) {
                if (!(element instanceof Layout)) continue;
                Layout layout = (Layout)element;
                this._lazyInitialize(layout.getChildren());
                for (Element layoutElement : layout.getChildren()) {
                    if (!(element instanceof Toolbar)) continue;
                    Toolbar toolbar = (Toolbar)layoutElement;
                    this._lazyInitialize(toolbar.getChildren());
                }
            }
        }
    }

    private void _lazyInitialize(List<Element> elements) {
        for (Element element : elements) {
            if (element instanceof ControlRef) {
                ControlRef control = (ControlRef)element;
                Object ribbonControl = this._ribbonControlManager.getExtension(control.getId());
                if (ribbonControl == null) {
                    String errorMessage = "An item referes an unexisting item factory with id '" + control.getId() + "'";
                    _logger.error(errorMessage);
                    throw new IllegalStateException(errorMessage);
                }
                this._controlsReferences.add(control.getId());
                continue;
            }
            if (!(element instanceof Toolbar)) continue;
            Toolbar toolbar = (Toolbar)element;
            this._lazyInitialize(toolbar.getChildren());
        }
    }

    public List<ClientSideElement> getControls() {
        ArrayList<ClientSideElement> controlsList = new ArrayList<ClientSideElement>();
        for (String controlId : this._controlsReferences) {
            Object control = this._ribbonControlManager.getExtension(controlId);
            controlsList.add((ClientSideElement)control);
            if (!(control instanceof MenuClientSideElement)) continue;
            controlsList.addAll(this._getMenuControls((MenuClientSideElement)control));
        }
        return controlsList;
    }

    public List<ClientSideElement> getTabs() {
        ArrayList<ClientSideElement> tabsList = new ArrayList<ClientSideElement>();
        for (String tabId : this._tabsReferences) {
            Object tab = this._ribbonTabManager.getExtension(tabId);
            tabsList.add((ClientSideElement)tab);
        }
        return tabsList;
    }

    private List<ClientSideElement> _getMenuControls(MenuClientSideElement menu) {
        ArrayList<ClientSideElement> controlsList = new ArrayList<ClientSideElement>();
        for (ClientSideElement element : menu.getReferencedClientSideElements()) {
            controlsList.add(element);
            if (!(element instanceof MenuClientSideElement)) continue;
            controlsList.addAll(this._getMenuControls((MenuClientSideElement)((Object)element)));
        }
        return controlsList;
    }

    public void saxRibbonDefinition(ContentHandler handler, Map<String, Object> contextualParameters) throws SAXException {
        this._lazyInitialize();
        Map<Tab, List<Group>> userTabGroups = this._generateTabGroups(contextualParameters);
        List<Element> currentAppMenu = this._resolveReferences(contextualParameters, this._ribbonConfig.getAppMenu().getElements());
        List<Element> currentUserMenu = this._resolveReferences(contextualParameters, this._ribbonConfig.getUserMenu().getElements());
        handler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
        XMLUtils.startElement((ContentHandler)handler, (String)"ribbon");
        XMLUtils.startElement((ContentHandler)handler, (String)"controls");
        for (String string : this._controlsReferences) {
            Object control = this._ribbonControlManager.getExtension(string);
            this._saxClientSideElementHelper.saxDefinition("control", (ClientSideElement)control, RibbonControlsManager.ROLE, handler, contextualParameters);
            if (!(control instanceof MenuClientSideElement)) continue;
            this._saxReferencedControl((MenuClientSideElement)control, handler, contextualParameters);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"controls");
        XMLUtils.startElement((ContentHandler)handler, (String)"tabsControls");
        for (String string : this._tabsReferences) {
            Object tab = this._ribbonTabManager.getExtension(string);
            this._saxClientSideElementHelper.saxDefinition("tab", (ClientSideElement)tab, RibbonTabsManager.ROLE, handler, contextualParameters);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"tabsControls");
        XMLUtils.startElement((ContentHandler)handler, (String)"app-menu");
        for (Element element : currentAppMenu) {
            element.toSAX(handler);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"app-menu");
        XMLUtils.startElement((ContentHandler)handler, (String)"user-menu");
        for (Element element : currentUserMenu) {
            element.toSAX(handler);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"user-menu");
        XMLUtils.startElement((ContentHandler)handler, (String)"tabs");
        for (Map.Entry entry : userTabGroups.entrySet()) {
            ((Tab)entry.getKey()).saxGroups(handler, (List)entry.getValue());
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"tabs");
        XMLUtils.endElement((ContentHandler)handler, (String)"ribbon");
        handler.endPrefixMapping("i18n");
    }

    private Map<Tab, List<Group>> _generateTabGroups(Map<String, Object> contextualParameters) {
        LinkedHashMap<Tab, List<Group>> tabGroups = new LinkedHashMap<Tab, List<Group>>();
        for (Tab tab : this._ribbonConfig.getTabs()) {
            ArrayList<Group> tabGroup = new ArrayList<Group>();
            for (Group group : tab.getGroups()) {
                Group newGroup = this._createGroupForUser(group, contextualParameters);
                if (newGroup.isEmpty()) continue;
                tabGroup.add(newGroup);
            }
            if (tabGroup.isEmpty()) continue;
            tabGroups.put(tab, tabGroup);
        }
        this._checkTabConsistency(tabGroups);
        return tabGroups;
    }

    private void _checkTabConsistency(Map<Tab, List<Group>> tabGroups) {
        for (Map.Entry<Tab, List<Group>> entry : tabGroups.entrySet()) {
            for (Group group : entry.getValue()) {
                GroupSize small;
                GroupSize medium;
                GroupSize large = group.getLargeGroupSize();
                if (large != null) {
                    this._checkTabConsistency(large);
                }
                if ((medium = group.getMediumGroupSize()) != null) {
                    this._checkTabConsistency(medium);
                }
                if ((small = group.getSmallGroupSize()) == null) continue;
                this._checkTabConsistency(small);
            }
        }
    }

    private void _checkTabConsistency(GroupSize group) {
        ArrayList<Layout> layoutsBuffer = new ArrayList<Layout>();
        List<Element> originalChildren = group.getChildren();
        for (int i = 0; i < originalChildren.size(); ++i) {
            Element originalChild = originalChildren.get(i);
            if (originalChild instanceof Layout & originalChild.getColumns() == 1) {
                Layout originalLayout = (Layout)originalChild;
                if (layoutsBuffer.size() > 0) {
                    CONTROLSIZE originalLayoutSize = originalLayout.getSize();
                    LAYOUTALIGN originalLayoutAlign = originalLayout.getAlign();
                    if ((originalLayoutSize == null ? ((Layout)layoutsBuffer.get(0)).getSize() != null : !originalLayoutSize.equals((Object)((Layout)layoutsBuffer.get(0)).getSize())) || (originalLayoutAlign != null ? !originalLayoutAlign.equals((Object)((Layout)layoutsBuffer.get(0)).getAlign()) : ((Layout)layoutsBuffer.get(0)).getAlign() != null)) {
                        this._checkLayoutsConsistency(layoutsBuffer, group);
                    }
                }
                layoutsBuffer.add(originalLayout);
                continue;
            }
            if (layoutsBuffer.size() <= 0) continue;
            this._checkLayoutsConsistency(layoutsBuffer, group);
        }
        if (layoutsBuffer.size() > 0) {
            this._checkLayoutsConsistency(layoutsBuffer, group);
        }
    }

    private void _checkLayoutsConsistency(List<Layout> layoutsBuffer, GroupSize group) {
        int elementsPerLayout;
        LAYOUTALIGN align = layoutsBuffer.get(0).getAlign();
        CONTROLSIZE size = layoutsBuffer.get(0).getSize();
        int n = elementsPerLayout = LAYOUTALIGN.MIDDLE.equals((Object)align) ? 2 : 3;
        while (layoutsBuffer.size() > 0) {
            int currentSize;
            List<Element> elements;
            Layout layout = layoutsBuffer.remove(0);
            Layout newLayout = this._checkLayoutsOverflow(size, elementsPerLayout, layout, elements = layout.getChildren(), currentSize = elements.stream().mapToInt(Element::getColumns).sum());
            if (newLayout != null) {
                layoutsBuffer.add(0, newLayout);
                group.getChildren().add(group.getChildren().indexOf(layout) + 1, newLayout);
            }
            this._checkLayoutsMerge(layoutsBuffer, elementsPerLayout, layout, elements, currentSize, group);
        }
    }

    private Layout _checkLayoutsOverflow(CONTROLSIZE size, int elementsPerLayout, Layout layout, List<Element> elements, int currentSize) {
        int layoutCols = layout.getColumns();
        if (currentSize > layoutCols * elementsPerLayout) {
            Layout newLayout = new Layout(layout, size);
            int position = 0;
            for (Element element : elements) {
                if ((position += element.getColumns()) <= layoutCols * elementsPerLayout) continue;
                newLayout.getChildren().add(element);
            }
            elements.removeAll(newLayout.getChildren());
            return newLayout;
        }
        return null;
    }

    private void _checkLayoutsMerge(List<Layout> layoutsBuffer, int elementsPerLayout, Layout layout, List<Element> elements, int layoutSize, GroupSize group) {
        boolean canFitMore;
        int currentSize = layoutSize;
        int layoutCols = layout.getColumns();
        boolean bl = canFitMore = currentSize < layoutCols * elementsPerLayout;
        while (canFitMore && layoutsBuffer.size() > 0) {
            Layout nextLayout = layoutsBuffer.get(0);
            if (nextLayout.getColumns() > layoutCols) {
                layout.setColumns(nextLayout.getColumns());
                layoutCols = nextLayout.getColumns();
            }
            List<Element> nextChildren = nextLayout.getChildren();
            while (canFitMore && nextChildren.size() > 0) {
                int columnsLeft;
                Element nextChild = nextChildren.get(0);
                int nextChildColumns = nextChild.getColumns();
                if (nextChildColumns > layoutCols) {
                    layout.setColumns(nextChildColumns);
                    layoutCols = nextChildColumns;
                }
                if ((columnsLeft = layoutCols - currentSize % layoutCols) < nextChildColumns) {
                    Element previousElement = elements.get(elements.size() - 1);
                    previousElement.setColumns(previousElement.getColumns() + columnsLeft);
                    currentSize += columnsLeft;
                }
                if (currentSize + nextChildColumns <= layoutCols * elementsPerLayout) {
                    nextChildren.remove(nextChild);
                    elements.add(nextChild);
                    currentSize += nextChildColumns;
                    continue;
                }
                canFitMore = false;
            }
            if (nextChildren.size() == 0) {
                layoutsBuffer.remove(nextLayout);
                group.getChildren().remove(nextLayout);
            }
            if (currentSize != layoutCols * elementsPerLayout) continue;
            canFitMore = false;
        }
    }

    private Group _createGroupForUser(Group ribbonGroup, Map<String, Object> contextualParameters) {
        Group group = new Group(ribbonGroup);
        GroupSize largeSize = group.getLargeGroupSize();
        GroupSize mediumSize = group.getMediumGroupSize();
        GroupSize smallSize = group.getSmallGroupSize();
        if (ribbonGroup.getLargeGroupSize() != null) {
            List<Element> largeElements = this._resolveReferences(contextualParameters, ribbonGroup.getLargeGroupSize().getChildren());
            largeSize.getChildren().addAll(largeElements);
        }
        if (ribbonGroup.getMediumGroupSize() == null) {
            this._generateGroupSizes(largeSize.getChildren(), mediumSize.getChildren(), false, largeSize.getControlIds().size());
            this._generateGroupSizes(largeSize.getChildren(), smallSize.getChildren(), true, largeSize.getControlIds().size());
        } else {
            List<Element> mediumElements = this._resolveReferences(contextualParameters, ribbonGroup.getMediumGroupSize().getChildren());
            mediumSize.getChildren().addAll(mediumElements);
            if (ribbonGroup.getSmallGroupSize() != null) {
                List<Element> largeElements = this._resolveReferences(contextualParameters, ribbonGroup.getSmallGroupSize().getChildren());
                smallSize.getChildren().addAll(largeElements);
            }
        }
        if (mediumSize.isSame(largeSize)) {
            largeSize.getChildren().clear();
        }
        if (mediumSize.isSame(smallSize)) {
            smallSize.getChildren().clear();
        }
        return group;
    }

    private List<Element> _resolveReferences(Map<String, Object> contextualParameters, List<Element> elements) {
        ArrayList<Element> resolvedElements = new ArrayList<Element>();
        for (Element element : elements) {
            List<Element> toolbarElements;
            List<Element> layoutElements;
            if (element instanceof ControlRef) {
                ControlRef controlRef = (ControlRef)element;
                Object extension = this._ribbonControlManager.getExtension(controlRef.getId());
                for (ClientSideElement.Script script : extension.getScripts(contextualParameters)) {
                    resolvedElements.add(new ControlRef(script.getId(), controlRef.getColumns(), _logger));
                }
            }
            if (element instanceof Layout && (layoutElements = this._resolveReferences(contextualParameters, element.getChildren())).size() > 0) {
                Layout layout = (Layout)element;
                Layout resolvedLayout = new Layout(layout, layout.getSize());
                resolvedLayout.getChildren().addAll(layoutElements);
                resolvedElements.add(resolvedLayout);
            }
            if (element instanceof Toolbar && (toolbarElements = this._resolveReferences(contextualParameters, element.getChildren())).size() > 0) {
                Toolbar toolbar = (Toolbar)element;
                Toolbar resolvedToolbar = new Toolbar(_logger, toolbar.getColumns());
                resolvedToolbar.getChildren().addAll(toolbarElements);
                resolvedElements.add(resolvedToolbar);
            }
            if (!(element instanceof Separator)) continue;
            resolvedElements.add(element);
        }
        while (resolvedElements.size() > 0 && resolvedElements.get(0) instanceof Separator) {
            resolvedElements.remove(0);
        }
        while (resolvedElements.size() > 0 && resolvedElements.get(resolvedElements.size() - 1) instanceof Separator) {
            resolvedElements.remove(resolvedElements.size() - 1);
        }
        return resolvedElements;
    }

    private void _generateGroupSizes(List<Element> largeElements, List<Element> groupSizeElements, boolean generateSmallSize, int groupTotalSize) {
        ArrayList<ControlRef> controlsQueue = new ArrayList<ControlRef>();
        for (Element largeElement : largeElements) {
            if (largeElement instanceof ControlRef) {
                controlsQueue.add((ControlRef)largeElement);
            }
            if (largeElement instanceof Toolbar) {
                this._processControlRefsQueue(controlsQueue, groupSizeElements, groupTotalSize, generateSmallSize);
                controlsQueue.clear();
                Toolbar toolbar = (Toolbar)largeElement;
                groupSizeElements.add(toolbar);
            }
            if (!(largeElement instanceof Layout)) continue;
            this._processControlRefsQueue(controlsQueue, groupSizeElements, groupTotalSize, generateSmallSize);
            controlsQueue.clear();
            Layout layout = (Layout)largeElement;
            Layout verySmallLayout = new Layout(layout, CONTROLSIZE.VERYSMALL);
            verySmallLayout.getChildren().addAll(layout.getChildren());
            groupSizeElements.add(verySmallLayout);
        }
        this._processControlRefsQueue(controlsQueue, groupSizeElements, groupTotalSize, generateSmallSize);
    }

    private void _processControlRefsQueue(List<ControlRef> controlsQueue, List<Element> groupSizeElements, int groupTotalSize, boolean generateSmallSize) {
        ArrayList<ControlRef> controlsBuffer;
        int queueSize = controlsQueue.size();
        for (int index = 0; index < queueSize; index += controlsBuffer.size()) {
            controlsBuffer = new ArrayList<ControlRef>();
            while (controlsBuffer.size() == 0 || controlsBuffer.size() < 3 && controlsBuffer.size() + index != queueSize % 3) {
                controlsBuffer.add(controlsQueue.get(index + controlsBuffer.size()));
            }
            if (index == 0) {
                if (groupTotalSize > 1 && groupTotalSize <= 3) {
                    Layout newLayout = new Layout(1, CONTROLSIZE.SMALL, LAYOUTALIGN.TOP, _logger);
                    newLayout.getChildren().addAll(controlsBuffer);
                    groupSizeElements.add(newLayout);
                    continue;
                }
                groupSizeElements.addAll(controlsBuffer);
                continue;
            }
            CONTROLSIZE controlSize = generateSmallSize && index >= 0 ? CONTROLSIZE.VERYSMALL : CONTROLSIZE.SMALL;
            Layout newLayout = new Layout(1, controlSize, LAYOUTALIGN.TOP, _logger);
            newLayout.getChildren().addAll(controlsBuffer);
            groupSizeElements.add(newLayout);
        }
    }

    private void _saxReferencedControl(MenuClientSideElement menu, ContentHandler handler, Map<String, Object> contextualParameters) throws SAXException {
        List<ClientSideElement> referencedControl = menu.getReferencedClientSideElements();
        for (ClientSideElement element : referencedControl) {
            if (!this._controlsReferences.contains(element.getId())) {
                this._saxClientSideElementHelper.saxDefinition("control", element, RibbonControlsManager.ROLE, handler, contextualParameters);
            }
            if (!(element instanceof MenuClientSideElement)) continue;
            this._saxReferencedControl((MenuClientSideElement)((Object)element), handler, contextualParameters);
        }
    }

    public static enum LAYOUTALIGN {
        TOP("top"),
        MIDDLE("middle");

        private String _value;

        private LAYOUTALIGN(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public static LAYOUTALIGN createsFromString(String align) {
            for (LAYOUTALIGN v : LAYOUTALIGN.values()) {
                if (!v.toString().equals(align)) continue;
                return v;
            }
            return null;
        }
    }

    public static enum CONTROLSIZE {
        LARGE("large"),
        SMALL("small"),
        VERYSMALL("very-small");

        private String _value;

        private CONTROLSIZE(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public static CONTROLSIZE createsFromString(String size) {
            for (CONTROLSIZE v : CONTROLSIZE.values()) {
                if (!v.toString().equals(size)) continue;
                return v;
            }
            return null;
        }
    }
}

