/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.help.HelpManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SAXClientSideElementHelper
extends AbstractLogEnabled
implements Contextualizable,
Component,
Serviceable,
ThreadSafe {
    public static final String ROLE = SAXClientSideElementHelper.class.getName();
    protected Context _context;
    private JSONUtils _jsonUtils;
    private HelpManager _helpManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._helpManager = (HelpManager)smanager.lookup(HelpManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void saxDefinition(String tagName, ClientSideElement element, String extensionPoint, ContentHandler handler, Map<String, Object> contextualParameters) throws SAXException {
        try {
            List<ClientSideElement.Script> scripts = element.getScripts(contextualParameters);
            Map objectModel = ContextHelper.getObjectModel((Context)this._context);
            Locale locale = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
            String langCode = locale.getLanguage();
            for (ClientSideElement.Script script : scripts) {
                AttributesImpl clientSideElementAttrs = new AttributesImpl();
                String scriptId = script.getId();
                try {
                    String help = this._helpManager.getHelp(extensionPoint, scriptId, langCode);
                    if (StringUtils.isNotBlank((CharSequence)help)) {
                        clientSideElementAttrs.addCDATAAttribute("help", help);
                    }
                }
                catch (Exception e) {
                    this.getLogger().warn("Error while getting help url for extion point : '{}' for id : '{}'", new Object[]{extensionPoint, scriptId, e});
                }
                clientSideElementAttrs.addCDATAAttribute("id", scriptId);
                clientSideElementAttrs.addCDATAAttribute("serverId", script.getServerId());
                clientSideElementAttrs.addCDATAAttribute("plugin", element.getPluginName());
                XMLUtils.startElement((ContentHandler)handler, (String)tagName, (Attributes)clientSideElementAttrs);
                Map<String, Object> parameters = script.getParameters();
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("class", script.getScriptClassname());
                XMLUtils.createElement((ContentHandler)handler, (String)"action", (Attributes)attrs, (String)this._jsonUtils.convertObjectToJson(parameters));
                XMLUtils.startElement((ContentHandler)handler, (String)"scripts");
                for (ClientSideElement.ScriptFile scriptFile : script.getScriptFiles()) {
                    this.saxScriptFile(handler, scriptFile);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"scripts");
                XMLUtils.startElement((ContentHandler)handler, (String)"css");
                for (ClientSideElement.ScriptFile scriptFile : script.getCSSFiles()) {
                    this.saxScriptFile(handler, scriptFile);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"css");
                XMLUtils.endElement((ContentHandler)handler, (String)tagName);
            }
        }
        catch (Exception e) {
            throw new SAXException("An error occurred while saxing '" + extensionPoint + "#" + element.getPluginName() + "/" + element.getId() + "'", e);
        }
    }

    private void saxScriptFile(ContentHandler handler, ClientSideElement.ScriptFile scriptFile) throws SAXException {
        AttributesImpl fileAttrs = new AttributesImpl();
        if (!scriptFile.isLangSpecific()) {
            String rtlMode = scriptFile.getRtlMode();
            if (rtlMode != null && !"all".equals(rtlMode)) {
                fileAttrs.addCDATAAttribute("rtl", rtlMode);
            }
            XMLUtils.createElement((ContentHandler)handler, (String)"file", (Attributes)fileAttrs, (String)scriptFile.getPath());
        } else {
            fileAttrs.addCDATAAttribute("lang", "true");
            XMLUtils.startElement((ContentHandler)handler, (String)"file", (Attributes)fileAttrs);
            String defaultLang = scriptFile.getDefaultLang();
            Map<String, String> langPaths = scriptFile.getLangPaths();
            for (Map.Entry<String, String> langPath : langPaths.entrySet()) {
                AttributesImpl langAttrs = new AttributesImpl();
                String codeLang = langPath.getKey();
                langAttrs.addCDATAAttribute("code", codeLang);
                if (codeLang.equals(defaultLang)) {
                    langAttrs.addCDATAAttribute("default", "true");
                }
                XMLUtils.createElement((ContentHandler)handler, (String)"lang", (Attributes)langAttrs, (String)langPath.getValue());
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"file");
        }
    }
}

