/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SAXClientSideElementHelper;
import org.ametys.core.ui.UIToolsFactoriesManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UIToolsConfigurationManager {
    private static Logger _logger = LoggerFactory.getLogger(UIToolsConfigurationManager.class);
    protected Map<String, String> _defaultUITools = new LinkedHashMap<String, String>();
    protected UIToolsFactoriesManager _uitoolsFactoriesManager;
    protected SAXClientSideElementHelper _saxClientSideElementHelper;
    protected String[] _additionalDefaultTools;

    public UIToolsConfigurationManager(UIToolsFactoriesManager uitoolsFactoriesManager, SAXClientSideElementHelper saxClientSideElementHelper, Source configSource, Request request) {
        this._uitoolsFactoriesManager = uitoolsFactoriesManager;
        this._saxClientSideElementHelper = saxClientSideElementHelper;
        try {
            DefaultConfiguration configuration = null;
            if (configSource.exists()) {
                try (InputStream configIs = configSource.getInputStream();){
                    configuration = new DefaultConfigurationBuilder().build(configIs);
                }
            } else {
                configuration = new DefaultConfiguration("default");
            }
            this._configure((Configuration)configuration);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read the configuration file", e);
        }
        this._additionalDefaultTools = request.getParameterValues("uitool");
    }

    private void _configure(Configuration configuration) throws ConfigurationException {
        Configuration[] defaultUIToolFactoryConfigurations;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Starting reading uitools configuration");
        }
        for (Configuration uitoolFactoryConfiguration : defaultUIToolFactoryConfigurations = configuration.getChild("default").getChildren("uitool-factory")) {
            String id = uitoolFactoryConfiguration.getAttribute("id");
            String parameters = uitoolFactoryConfiguration.getValue("");
            this._defaultUITools.put(id, parameters);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Ending reading uitools configuration");
        }
    }

    public void saxDefaultState(ContentHandler handler, Map<String, Object> contextualParameters, List<ClientSideElement> dependenciesList) throws SAXException {
        handler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
        XMLUtils.startElement((ContentHandler)handler, (String)"uitools-factories");
        XMLUtils.startElement((ContentHandler)handler, (String)"default");
        for (String id : this._defaultUITools.keySet()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", id);
            XMLUtils.createElement((ContentHandler)handler, (String)"uitool-factory", (Attributes)attrs, (String)this._defaultUITools.get(id));
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"default");
        XMLUtils.startElement((ContentHandler)handler, (String)"additionnal");
        if (this._additionalDefaultTools != null) {
            for (String additionnalTool : this._additionalDefaultTools) {
                if (StringUtils.isEmpty((CharSequence)additionnalTool)) continue;
                int i = additionnalTool.indexOf(",");
                String id = additionnalTool.trim();
                String params = "";
                if (i != -1) {
                    id = additionnalTool.substring(0, i).trim();
                    params = additionnalTool.substring(i + 1).trim();
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("id", id);
                XMLUtils.createElement((ContentHandler)handler, (String)"uitool-factory", (Attributes)attrs, (String)params);
            }
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"additionnal");
        if (dependenciesList != null) {
            for (ClientSideElement factory : dependenciesList) {
                this._saxClientSideElementHelper.saxDefinition("uitool-factory", factory, UIToolsFactoriesManager.ROLE, handler, contextualParameters);
            }
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"uitools-factories");
        handler.endPrefixMapping("i18n");
    }
}

