/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.slf4j.Logger;

public class RibbonExclude {
    private EXCLUDETYPE _type;
    private EXCLUDETARGET _target;
    private String _value;
    private Logger _logger;

    public RibbonExclude(Configuration configuration, Logger logger) throws ConfigurationException {
        this._logger = logger;
        String type = configuration.getName();
        String target = configuration.getAttribute("type", null);
        this._value = configuration.getValue();
        this._type = EXCLUDETYPE.createsFromString(type);
        if (EXCLUDETYPE.CONTROL.equals((Object)this._type) && target == null) {
            target = "id";
        }
        this._target = EXCLUDETARGET.createsFromString(target);
        if (this._type == null || this._target == null || this._value == null) {
            throw new ConfigurationException("Invalid exclude tag '" + type + "' in the ribbon configuration", configuration);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("RibbonConfigurationManager : Exclusion of " + type + " with target '" + target + "' and value '" + this._value + "'");
        }
    }

    public EXCLUDETYPE getType() {
        return this._type;
    }

    public EXCLUDETARGET getTarget() {
        return this._target;
    }

    public String getValue() {
        return this._value;
    }

    public static enum EXCLUDETARGET {
        PLUGIN("plugin"),
        EXTENSION("extension"),
        FILE("file"),
        LABEL("label"),
        ID("id");

        private String _value;

        private EXCLUDETARGET(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public static EXCLUDETARGET createsFromString(String target) {
            for (EXCLUDETARGET v : EXCLUDETARGET.values()) {
                if (!v.toString().equals(target)) continue;
                return v;
            }
            return null;
        }
    }

    public static enum EXCLUDETYPE {
        IMPORT("import"),
        APPMENU("app-menu"),
        USERMENU("user-menu"),
        TAB("tab"),
        CONTROL("control");

        private String _value;

        private EXCLUDETYPE(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public static EXCLUDETYPE createsFromString(String type) {
            for (EXCLUDETYPE v : EXCLUDETYPE.values()) {
                if (!v.toString().equals(type)) continue;
                return v;
            }
            return null;
        }
    }
}

