/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.ArrayList;
import java.util.List;
import org.ametys.core.ui.ribbonconfiguration.Element;
import org.ametys.core.ui.ribbonconfiguration.RibbonElementsInjectionHelper;
import org.slf4j.Logger;

public class RibbonMenu {
    protected List<Element> _menuElements = new ArrayList<Element>();
    private RibbonElementsInjectionHelper<Element> _injectionHelper;

    public List<Element> getElements() {
        return this._menuElements;
    }

    public void addElements(List<Element> elements, String order, Logger logger) {
        if (elements.size() == 0) {
            return;
        }
        if (this._injectionHelper == null) {
            this._injectionHelper = new RibbonElementsInjectionHelper<Element>(this._menuElements, logger);
        }
        for (Element element : elements) {
            this._injectionHelper.injectElements(element, order);
        }
    }

    public static enum MENUTYPE {
        APPMENU("app-menu"),
        USERMENU("user-menu");

        private String _value;

        private MENUTYPE(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public static MENUTYPE createsFromString(String type) {
            for (MENUTYPE v : MENUTYPE.values()) {
                if (!v.toString().equals(type)) continue;
                return v;
            }
            return null;
        }
    }
}

