/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.right;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.core.right.RightAssignmentContextExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightsException;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideElementHelper;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ProfileAssignmentsToolClientSideElement
extends StaticClientSideElement {
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected RightAssignmentContextExtensionPoint _rightAssignmentContextEP;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected GroupManager _groupManager;
    protected ObservationManager _observationManager;
    protected UserHelper _userHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)smanager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._rightAssignmentContextEP = (RightAssignmentContextExtensionPoint)smanager.lookup(RightAssignmentContextExtensionPoint.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
        this._observationManager = (ObservationManager)((Object)smanager.lookup(ObservationManager.ROLE));
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        List<ClientSideElement.Script> scripts = super.getScripts(ignoreRights, contextParameters);
        if (scripts.size() > 0) {
            ClientSideElement.Script script = ClientSideElementHelper.cloneScript(scripts.get(0));
            HashMap jsClasses = new HashMap();
            script.getParameters().put("classes", jsClasses);
            boolean excludePrivate = true;
            HashSet<String> rightContextIds = this._rightAssignmentContextEP.getExtensionsIds();
            if (script.getParameters().containsKey("right-contexts")) {
                excludePrivate = false;
                Object ctxConfig = ((Map)script.getParameters().get("right-contexts")).get("right-context");
                rightContextIds = ctxConfig instanceof List ? new HashSet<String>((List)ctxConfig) : Sets.newHashSet((Object[])new String[]{(String)ctxConfig});
            }
            for (String rightContextId : rightContextIds) {
                RightAssignmentContext rightAssignmentContext = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightContextId);
                if (excludePrivate && rightAssignmentContext.isPrivate()) continue;
                List<ClientSideElement.Script> rightAssignmentContextScripts = rightAssignmentContext.getScripts(ignoreRights, contextParameters);
                int index = 0;
                for (ClientSideElement.Script rightAssignmentContextScript : rightAssignmentContextScripts) {
                    HashMap<String, Object> classInfo = new HashMap<String, Object>();
                    classInfo.put("className", rightAssignmentContextScript.getScriptClassname());
                    classInfo.put("serverId", rightContextId);
                    classInfo.put("parameters", rightAssignmentContextScript.getParameters());
                    jsClasses.put(rightContextId + "-" + index++, classInfo);
                    script.getScriptFiles().addAll(rightAssignmentContextScript.getScriptFiles());
                    script.getCSSFiles().addAll(rightAssignmentContextScript.getCSSFiles());
                }
            }
            scripts = new ArrayList<ClientSideElement.Script>();
            scripts.add(script);
        }
        return scripts;
    }

    @Callable
    public List<Map<String, Object>> getUserGroups(String login, String populationId) {
        return this._groupManager.getUserGroups(new UserIdentity(login, populationId)).stream().map(this::_groupToJson).collect(Collectors.toList());
    }

    private Map<String, Object> _groupToJson(GroupIdentity groupIdentity) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("groupId", groupIdentity.getId());
        result.put("groupDirectory", groupIdentity.getDirectoryId());
        return result;
    }

    @Callable
    public void saveChanges(String rightAssignmentCtxId, Object jsContext, List<Map<String, Object>> assignmentsInfo) {
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Runtime_Rights_Rights_Handle", "/${WorkspaceName}") != RightManager.RightResult.RIGHT_ALLOW) {
            throw new RightsException("The user '" + this._currentUserProvider.getUser() + "' try to assign profile without sufficient rights");
        }
        HashSet<String> updatedProfiles = new HashSet<String>();
        RightAssignmentContext rightAssignmentContext = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object context = rightAssignmentContext.convertJSContext(jsContext);
        String contextIdentifier = rightAssignmentContext.getContextIdentifier(context);
        for (Map<String, Object> assignmentInfo : assignmentsInfo) {
            String profileId = (String)assignmentInfo.get("profileId");
            updatedProfiles.add(profileId);
            String assignment = (String)assignmentInfo.get("assignment");
            String targetType = (String)assignmentInfo.get("targetType");
            Map identity = (Map)assignmentInfo.get("identity");
            this._saveChange(context, profileId, assignment, targetType, identity);
        }
        this._notifyObservers(context, contextIdentifier, updatedProfiles);
    }

    private void _notifyObservers(Object context, String contextIdentifier, Set<String> profileIds) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("acl-context", context);
        eventParams.put("acl-context-identifier", contextIdentifier);
        eventParams.put("acl-profiles", profileIds);
        this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), eventParams));
    }

    @Callable
    public Map<String, String> getInheritedAssignments(String rightAssignmentCtxId, Object jsContext, List<String> profileIds, String targetType, Map<String, String> identity) {
        HashMap<String, String> assignments = new HashMap<String, String>();
        for (String profileId : profileIds) {
            assignments.put(profileId, this.getInheritedAssignment(rightAssignmentCtxId, jsContext, profileId, targetType, identity));
        }
        return assignments;
    }

    @Callable
    public String getInheritedAssignment(String rightAssignmentCtxId, Object jsContext, String profileId, String targetType, Map<String, String> identity) {
        RightAssignmentContext rightCtx = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object context = rightCtx.convertJSContext(jsContext);
        switch (TargetType.valueOf(targetType.toUpperCase())) {
            case ANONYMOUS: {
                return this._getInheritedAssignmentForAnonymous(rightCtx, context, profileId);
            }
            case ANYCONNECTED_USER: {
                return this._getInheritedAssignmentForAnyconnected(rightCtx, context, profileId);
            }
            case USER: {
                UserIdentity user = this._userHelper.json2userIdentity(identity);
                return this._getInheritedAssignmentForUser(rightCtx, context, profileId, user);
            }
            case GROUP: {
                GroupIdentity group = new GroupIdentity(identity.get("groupId"), identity.get("groupDirectory"));
                return this._getInheritedAssignmentForGroup(rightCtx, context, profileId, group);
            }
        }
        return AccessType.UNKNOWN.toString();
    }

    private String _getInheritedAssignmentForAnonymous(RightAssignmentContext extension, Object context, String profileId) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Set<String> deniedProfiles = this._profileAssignmentStorageEP.getDeniedProfilesForAnonymous(parentContext);
                if (deniedProfiles.contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Set<String> allowedProfiles = this._profileAssignmentStorageEP.getAllowedProfilesForAnonymous(parentContext);
                if (allowedProfiles.contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForAnonymous(extension, parentContext, profileId);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private String _getInheritedAssignmentForAnyconnected(RightAssignmentContext extension, Object context, String profileId) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Set<String> deniedProfiles = this._profileAssignmentStorageEP.getDeniedProfilesForAnyConnectedUser(parentContext);
                if (deniedProfiles.contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Set<String> allowedProfiles = this._profileAssignmentStorageEP.getAllowedProfilesForAnyConnectedUser(parentContext);
                if (allowedProfiles.contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForAnyconnected(extension, parentContext, profileId);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private String _getInheritedAssignmentForUser(RightAssignmentContext extension, Object context, String profileId, UserIdentity user) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Map<UserIdentity, Set<String>> deniedProfiles = this._profileAssignmentStorageEP.getDeniedProfilesForUsers(parentContext);
                if (deniedProfiles.containsKey(user) && deniedProfiles.get(user).contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Map<UserIdentity, Set<String>> allowedProfiles = this._profileAssignmentStorageEP.getAllowedProfilesForUsers(parentContext);
                if (allowedProfiles.containsKey(user) && allowedProfiles.get(user).contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForUser(extension, parentContext, profileId, user);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private String _getInheritedAssignmentForGroup(RightAssignmentContext extension, Object context, String profileId, GroupIdentity group) {
        String value = AccessType.UNKNOWN.toString();
        Set<Object> parentContexts = extension.getParentContexts(context);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                Map<GroupIdentity, Set<String>> deniedProfiles = this._profileAssignmentStorageEP.getDeniedProfilesForGroups(parentContext);
                if (deniedProfiles.containsKey(group) && deniedProfiles.get(group).contains(profileId)) {
                    return AccessType.INHERITED_DENY.toString();
                }
                Map<GroupIdentity, Set<String>> allowedProfiles = this._profileAssignmentStorageEP.getAllowedProfilesForGroups(parentContext);
                if (allowedProfiles.containsKey(group) && allowedProfiles.get(group).contains(profileId)) {
                    value = AccessType.INHERITED_ALLOW.toString();
                }
                String parentsValue = this._getInheritedAssignmentForGroup(extension, parentContext, profileId, group);
                if (AccessType.UNKNOWN.toString().equals(parentsValue)) continue;
                value = parentsValue;
            }
        }
        return value;
    }

    private void _saveChange(Object context, String profileId, String assignment, String targetType, Map<String, String> identity) {
        AccessType accessType = assignment != null ? AccessType.valueOf(assignment.toUpperCase()) : AccessType.UNKNOWN;
        block0 : switch (TargetType.valueOf(targetType.toUpperCase())) {
            case ANONYMOUS: {
                switch (accessType) {
                    case ALLOW: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromAnonymous(profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToAnonymous(profileId, context);
                        break block0;
                    }
                    case DENY: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromAnonymous(profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToAnonymous(profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromAnonymous(profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromAnonymous(profileId, context);
                break;
            }
            case ANYCONNECTED_USER: {
                switch (accessType) {
                    case ALLOW: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromAnyConnectedUser(profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToAnyConnectedUser(profileId, context);
                        break block0;
                    }
                    case DENY: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromAnyConnectedUser(profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToAnyConnectedUser(profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromAnyConnectedUser(profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromAnyConnectedUser(profileId, context);
                break;
            }
            case USER: {
                UserIdentity user = this._userHelper.json2userIdentity(identity);
                switch (accessType) {
                    case ALLOW: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromUser(user, profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToUser(user, profileId, context);
                        break block0;
                    }
                    case DENY: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromUser(user, profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToUser(user, profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromUser(user, profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromUser(user, profileId, context);
                break;
            }
            case GROUP: {
                GroupIdentity group = new GroupIdentity(identity.get("groupId"), identity.get("groupDirectory"));
                switch (accessType) {
                    case ALLOW: {
                        this._profileAssignmentStorageEP.removeDeniedProfileFromGroup(group, profileId, context);
                        this._profileAssignmentStorageEP.allowProfileToGroup(group, profileId, context);
                        break block0;
                    }
                    case DENY: {
                        this._profileAssignmentStorageEP.removeAllowedProfileFromGroup(group, profileId, context);
                        this._profileAssignmentStorageEP.denyProfileToGroup(group, profileId, context);
                        break block0;
                    }
                }
                this._profileAssignmentStorageEP.removeAllowedProfileFromGroup(group, profileId, context);
                this._profileAssignmentStorageEP.removeDeniedProfileFromGroup(group, profileId, context);
                break;
            }
        }
    }

    public static enum TargetType {
        ANONYMOUS{

            public String toString() {
                return "anonymous";
            }
        }
        ,
        ANYCONNECTED_USER{

            public String toString() {
                return "anyconnected_user";
            }
        }
        ,
        USER{

            public String toString() {
                return "user";
            }
        }
        ,
        GROUP{

            public String toString() {
                return "group";
            }
        };

    }

    public static enum AccessType {
        ALLOW{

            public String toString() {
                return "allow";
            }
        }
        ,
        DENY{

            public String toString() {
                return "deny";
            }
        }
        ,
        INHERITED_ALLOW{

            public String toString() {
                return "inherited_allow";
            }
        }
        ,
        INHERITED_DENY{

            public String toString() {
                return "inherited_deny";
            }
        }
        ,
        UNKNOWN{

            public String toString() {
                return "unknown";
            }
        };

    }
}

