/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.population;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.notificator.AbstractConfigurableAdministratorNotificator;
import org.ametys.runtime.plugins.admin.notificator.Notification;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class IgnoredPopulationAdministratorNotificator
extends AbstractConfigurableAdministratorNotificator
implements Serviceable {
    private UserPopulationDAO _userPopulationDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
    }

    @Override
    public List<Notification> getNotifications() {
        Set<String> misconfiguredPopulations = this._userPopulationDAO.getIgnoredPopulations();
        if (!misconfiguredPopulations.isEmpty()) {
            String parameter = this._getParameter(misconfiguredPopulations);
            I18nizableText message = new I18nizableText(this._message.getCatalogue(), this._message.getKey(), Collections.singletonList(parameter));
            Notification notification = new Notification(this._type, this._title, message, this._iconGlyph, this._action);
            return Collections.singletonList(notification);
        }
        return Collections.EMPTY_LIST;
    }

    private String _getParameter(Set<String> populations) {
        StringBuilder sb = new StringBuilder();
        for (String id : populations) {
            sb.append("<li>").append(id).append("</li>");
        }
        return sb.toString();
    }
}

