/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.population;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class PopulationContextHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = PopulationContextHelper.class.getName();
    public static final String POPULATION_CONTEXTS_REQUEST_ATTR = "populationContexts";
    public static final String ADMIN_CONTEXT = "/admin";
    protected static final String __USER_POPULATIONS_TABLE = "UserPopulationsByContext";
    protected static final String __ADMIN_RIGHT_ACCESS = "Runtime_Rights_Admin_Access";
    protected ServiceManager _manager;
    private UserPopulationDAO _userPopulationDAO;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    protected ObservationManager getObservationManager() {
        if (this._observationManager == null) {
            try {
                this._observationManager = (ObservationManager)((Object)this._manager.lookup(ObservationManager.ROLE));
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._observationManager;
    }

    protected UserPopulationDAO getUserPopulationDAO() {
        if (this._userPopulationDAO == null) {
            try {
                this._userPopulationDAO = (UserPopulationDAO)this._manager.lookup(UserPopulationDAO.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._userPopulationDAO;
    }

    protected CurrentUserProvider getCurrentUserProvider() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._currentUserProvider;
    }

    protected RightManager getRightManager() {
        if (this._rightManager == null) {
            try {
                this._rightManager = (RightManager)this._manager.lookup(RightManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._rightManager;
    }

    protected Connection getSQLConnection() {
        String datasourceId = (String)Config.getInstance().getValue("runtime.assignments.userpopulations");
        return ConnectionHelper.getConnection(datasourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable
    public Set<String> link(String context, Collection<String> ids) {
        Set<String> result = this.getUserPopulationsOnContext(context, true);
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.getSQLConnection();
            String sql = "DELETE FROM UserPopulationsByContext WHERE Context=?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, context);
            stmt.executeUpdate();
            this.getLogger().info("{}\n[{}]", (Object)sql, (Object)context);
            sql = "INSERT INTO UserPopulationsByContext (Context, Ordering, UserPopulation_Id) VALUES(?, ?, ?)";
            stmt = connection.prepareStatement(sql);
            int index = 0;
            for (String id : ids) {
                if (this.getUserPopulationDAO().getUserPopulation(id) != null) {
                    stmt.setString(1, context);
                    stmt.setInt(2, index);
                    stmt.setString(3, id);
                    stmt.executeUpdate();
                    this.getLogger().info("{}\n[{}, {}, {}]", new Object[]{sql, context, index, id});
                    if (result.contains(id)) {
                        result.remove(id);
                    } else {
                        result.add(id);
                    }
                } else {
                    this.getLogger().warn("The user population with id '{}' does not exist. It will not be linked.", (Object)id);
                }
                ++index;
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("SQL error while linking user populations to a context", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                throw throwable;
            }
            ConnectionHelper.cleanup(connection);
            ConnectionHelper.cleanup(stmt);
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("userpopulation-ids", ids);
        eventParams.put("userpopulation-context", context);
        this.getObservationManager().notify(new Event("userpopulations.assignment", this.getCurrentUserProvider().getUser(), eventParams));
        return result;
    }

    public Set<String> getUserPopulationsOnContext(String context, boolean withDisabled) {
        if (ADMIN_CONTEXT.equals(context)) {
            List<UserPopulation> populations = withDisabled ? this.getUserPopulationDAO().getUserPopulations(true) : this.getUserPopulationDAO().getEnabledUserPopulations(true);
            return populations.stream().map(UserPopulation::getId).collect(Collectors.toSet());
        }
        return this._getPopulationsOnContextFromDatabase(context, withDisabled);
    }

    public Set<String> getUserPopulationsOnContexts(Collection<String> contexts, boolean withDisabled, boolean checkRights) {
        UserIdentity currentUser = this.getCurrentUserProvider().getUser();
        if (checkRights && contexts.contains(ADMIN_CONTEXT) && this.getRightManager().currentUserHasRight(__ADMIN_RIGHT_ACCESS, ADMIN_CONTEXT) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User " + this.getCurrentUserProvider().getUser() + " tried to access the list of all user populations without convenient rights");
        }
        if (!checkRights) {
            return contexts.stream().map(context -> this.getUserPopulationsOnContext((String)context, withDisabled)).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        if (currentUser == null) {
            throw new AccessDeniedException("Anonymous user tried to access the list of user populations on contexts '" + StringUtils.join(contexts, (String)",") + "'.");
        }
        boolean isAdministrator = this.getRightManager().currentUserHasRight(__ADMIN_RIGHT_ACCESS, ADMIN_CONTEXT) == RightManager.RightResult.RIGHT_ALLOW;
        HashSet<String> populations = new HashSet<String>();
        for (String context2 : contexts) {
            Set<String> ctxPopulations = this.getUserPopulationsOnContext(context2, withDisabled);
            if (!ctxPopulations.contains(currentUser.getPopulationId()) && !isAdministrator) {
                throw new AccessDeniedException("User " + currentUser + " tried to access the list of user populations on context '" + context2 + "', but he does not belong to any populations on this context.");
            }
            populations.addAll(ctxPopulations);
        }
        return populations;
    }

    @Callable
    public Set<String> getUserPopulationsOnContexts(Collection<String> contexts, boolean withDisabled) {
        return this.getUserPopulationsOnContexts(contexts, withDisabled, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getPopulationsOnContextFromDatabase(String context, boolean withDisabled) {
        HashSet<String> result = new HashSet<String>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT Context, Ordering, UserPopulation_Id FROM UserPopulationsByContext WHERE Context=? ORDER BY Ordering";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, context);
            rs = stmt.executeQuery();
            this.getLogger().info("{}\n[{}]", (Object)sql, (Object)context);
            while (rs.next()) {
                String userPopulationId = rs.getString(3);
                if (this.getUserPopulationDAO().getUserPopulation(userPopulationId) == null) {
                    this.getLogger().warn("The population of id '{}' is linked to a context, but does not exist anymore.", (Object)userPopulationId);
                    continue;
                }
                if (!withDisabled && !this.getUserPopulationDAO().getUserPopulation(userPopulationId).isEnabled()) {
                    this.getLogger().warn("The population of id '{}' is linked to a context but disabled. It will not be returned.", (Object)userPopulationId);
                    continue;
                }
                result.add(userPopulationId);
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error in sql query", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(rs);
                throw throwable;
            }
            ConnectionHelper.cleanup(connection);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(rs);
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLinked(String upId) {
        boolean result = false;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT UserPopulation_Id FROM UserPopulationsByContext WHERE UserPopulation_Id=?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, upId);
            rs = stmt.executeQuery();
            this.getLogger().info("{}\n[{}]", (Object)sql, (Object)upId);
            result = rs.next();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("SQL error while checking if the population is linked to a context", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(rs);
                throw throwable;
            }
            ConnectionHelper.cleanup(connection);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(rs);
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(rs);
        return result;
    }
}

