/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public final class DateUtils {
    private static DateTimeFormatter __ISO_OFFSET_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);

    private DateUtils() {
    }

    public static Instant asInstant(Date date) {
        return date == null ? null : date.toInstant();
    }

    public static ZonedDateTime asZonedDateTime(Date date, ZoneId zone) {
        return date == null ? null : DateUtils.asInstant(date).atZone(zone != null ? zone : ZoneId.systemDefault());
    }

    public static LocalDate asLocalDate(Date date, ZoneId zone) {
        return DateUtils.asZonedDateTime(date, zone).toLocalDate();
    }

    public static LocalDate asLocalDate(Date date) {
        return DateUtils.asLocalDate(date, ZoneId.systemDefault());
    }

    public static LocalDateTime asLocalDateTime(Date date, ZoneId zone) {
        return DateUtils.asZonedDateTime(date, zone).toLocalDateTime();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return DateUtils.asLocalDateTime(date, ZoneId.systemDefault());
    }

    public static Date asDate(LocalDate localDate) {
        return DateUtils.asDate(localDate, ZoneId.systemDefault());
    }

    public static Date asDate(LocalDate localDate, ZoneId zone) {
        return Date.from(localDate.atStartOfDay().atZone(zone).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return DateUtils.asDate(localDateTime, ZoneId.systemDefault());
    }

    public static Date asDate(LocalDateTime localDateTime, ZoneId zone) {
        return Date.from(localDateTime.atZone(zone).toInstant());
    }

    public static String formatDuration(Duration duration) {
        return DateUtils.formatDuration(duration.toMillis());
    }

    public static String formatDuration(long duration) {
        boolean showSeconds;
        StringBuilder sb = new StringBuilder();
        long durationCopy = duration;
        long ms = durationCopy % 1000L;
        long s = (durationCopy /= 1000L) % 60L;
        long m = (durationCopy /= 60L) % 60L;
        long h = (durationCopy /= 60L) % 24L;
        boolean showDays = (durationCopy /= 24L) > 0L;
        boolean showHours = showDays || h > 0L;
        boolean showMinuts = showHours || m > 0L;
        boolean bl = showSeconds = showMinuts || s > 0L;
        if (showDays) {
            sb.append(durationCopy);
            sb.append("j ");
        }
        if (showHours) {
            sb.append(DateUtils.formatNumber(h, 2));
            sb.append("h ");
        }
        if (showMinuts) {
            sb.append(DateUtils.formatNumber(m, 2));
            sb.append("m ");
        }
        if (showSeconds) {
            sb.append(DateUtils.formatNumber(s, 2));
            sb.append("s ");
        }
        sb.append(DateUtils.formatNumber(ms, 3));
        sb.append("ms");
        return sb.toString();
    }

    private static String formatNumber(long number, int nbNumbers) {
        String numberFormatted = String.valueOf(number);
        while (numberFormatted.length() < nbNumbers) {
            numberFormatted = "0" + numberFormatted;
        }
        return numberFormatted;
    }

    public static DateTimeFormatter getISODateTimeFormatter() {
        return __ISO_OFFSET_DATE_TIME;
    }

    public static String dateToString(Date value) {
        if (value == null) {
            return null;
        }
        ZonedDateTime zdt = DateUtils.asZonedDateTime(value, null);
        return zdt.format(DateUtils.getISODateTimeFormatter());
    }

    public static Date parse(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        LocalDateTime ldt = LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
        return DateUtils.asDate(ldt);
    }
}

