/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.cocoon.XMLResourceBundle;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.workspace.WorkspaceManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.i18n.BundleFactory;
import org.apache.cocoon.xml.ParamSaxBuffer;
import org.apache.cocoon.xml.SaxBuffer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class I18nUtils
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
Initializable,
Disposable {
    public static final String ROLE = I18nUtils.class.getName();
    private static I18nUtils _instance;
    protected Map<String, Location> _locations;
    protected Context _context;
    private BundleFactory _bundleFactory;
    private Map<String, Map<I18nizableText, String>> _cache;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._bundleFactory = (BundleFactory)manager.lookup(BundleFactory.ROLE);
    }

    public void initialize() throws Exception {
        _instance = this;
        this._cache = new HashMap<String, Map<I18nizableText, String>>();
        this._configure();
    }

    protected void _configure() {
        this._locations = new HashMap<String, Location>();
        this._locations.put("application", new Location("application", new String[]{"context://WEB-INF/i18n"}));
        PluginsManager pm = PluginsManager.getInstance();
        for (String pluginName : pm.getPluginNames()) {
            String id = "plugin." + pluginName;
            String location2 = "plugin:" + pluginName + "://i18n";
            this._locations.put(id, new Location("messages", new String[]{"context://WEB-INF/i18n/plugins/" + pluginName, location2}));
        }
        WorkspaceManager wm = WorkspaceManager.getInstance();
        for (String workspace : wm.getWorkspaceNames()) {
            String id = "workspace." + workspace;
            String location2 = "workspace:" + workspace + "://i18n";
            this._locations.put(id, new Location("messages", new String[]{"context://WEB-INF/i18n/workspaces/" + workspace, location2}));
        }
    }

    public void reloadCatalogues() {
        this.clearCache();
        this._configure();
    }

    public static I18nUtils getInstance() {
        return _instance;
    }

    public String translate(I18nizableText text) {
        return this.translate(text, null);
    }

    public String translate(I18nizableText text, String language) throws IllegalStateException {
        return this.translate(text, language, false);
    }

    public String translate(I18nizableText text, String language, boolean rawValue) throws IllegalStateException {
        String langCode = language;
        if (langCode == null) {
            Map objectModel = ContextHelper.getObjectModel((Context)this._context);
            Locale locale = org.apache.cocoon.i18n.I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
            langCode = locale.toString();
        }
        Map<I18nizableText, String> values = this.getLangCache(langCode);
        String value = null;
        if (rawValue) {
            value = this._translate(text, langCode, true);
        } else if (values.containsKey(text)) {
            value = values.get(text);
        } else {
            value = this._translate(text, langCode, false);
            if (value != null) {
                values.put(text, value);
            }
        }
        return value;
    }

    public void clearCache() {
        this._cache.clear();
    }

    protected Map<I18nizableText, String> getLangCache(String language) {
        HashMap<I18nizableText, String> langCache;
        if (this._cache.containsKey(language)) {
            langCache = this._cache.get(language);
        } else {
            langCache = new HashMap();
            this._cache.put(language, langCache);
        }
        return langCache;
    }

    protected String _translate(I18nizableText text, String language, boolean rawValue) throws IllegalStateException {
        if (!text.isI18n()) {
            return text.getLabel();
        }
        Location location = null;
        if (text.getLocation() != null) {
            location = new Location(text.getBundleName(), new String[]{text.getLocation()});
        } else {
            String catalogue = text.getCatalogue();
            location = this._locations.get(catalogue);
        }
        if (location == null) {
            return null;
        }
        try {
            SaxBuffer.Characters characters;
            ParamSaxBuffer buffer;
            Bundle bundle = this._bundleFactory.select(location.getLocations(), location.getName(), org.apache.cocoon.i18n.I18nUtils.parseLocale((String)language));
            ParamSaxBuffer paramSaxBuffer = buffer = rawValue ? (ParamSaxBuffer)((XMLResourceBundle)bundle).getRawObject(text.getKey()) : (ParamSaxBuffer)bundle.getObject(text.getKey());
            if (buffer == null) {
                return null;
            }
            HashMap<String, SaxBuffer> params = new HashMap<String, SaxBuffer>();
            if (text.getParameters() != null) {
                int p = 0;
                for (String param : text.getParameters()) {
                    characters = new SaxBuffer.Characters(param.toCharArray(), 0, param.length());
                    params.put(String.valueOf(p++), new SaxBuffer(Arrays.asList(characters)));
                }
            }
            if (text.getParameterMap() != null) {
                for (String name : text.getParameterMap().keySet()) {
                    String param;
                    param = this.translate(text.getParameterMap().get(name), language, rawValue);
                    if (param == null) {
                        param = "";
                    }
                    characters = new SaxBuffer.Characters(param.toCharArray(), 0, param.length());
                    params.put(name, new SaxBuffer(Arrays.asList(characters)));
                }
            }
            StringBuilder result = new StringBuilder();
            buffer.toSAX((ContentHandler)new BufferHandler(result), params);
            return result.toString();
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to get i18n translation", e);
        }
        catch (ComponentException e) {
            throw new RuntimeException("Unable to get i18n catalogue", e);
        }
    }

    public void dispose() {
        _instance = null;
    }

    protected class Location {
        String[] _loc;
        String _name;

        public Location(String name, String[] locations) {
            this._name = name;
            this._loc = locations;
        }

        public String getName() {
            return this._name;
        }

        public String[] getLocations() {
            return this._loc;
        }
    }

    private class BufferHandler
    extends DefaultHandler {
        StringBuilder _builder;

        public BufferHandler(StringBuilder builder) {
            this._builder = builder;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this._builder.append(ch, start, length);
        }
    }
}

