/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.dom;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.dom.AbstractWrappingAmetysElement;
import org.ametys.core.util.dom.AmetysAttribute;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileElement
extends AbstractWrappingAmetysElement<File> {
    public FileElement(File file) {
        this(file, null);
    }

    public FileElement(File file, FileElement parent) {
        super(file, (Element)parent);
    }

    @Override
    public String getTagName() {
        return ((File)this._object).isDirectory() ? "collection" : "resource";
    }

    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes() {
        HashMap<String, AmetysAttribute> result = new HashMap<String, AmetysAttribute>();
        result.put("name", new AmetysAttribute("name", "name", null, ((File)this._object).getName(), this));
        return result;
    }

    @Override
    public boolean hasChildNodes() {
        File[] files = ((File)this._object).listFiles();
        return files != null ? files.length > 0 : false;
    }

    @Override
    public Node getFirstChild() {
        File[] files = ((File)this._object).listFiles();
        if (files != null && files.length > 0) {
            return new FileElement(files[0], this);
        }
        return null;
    }

    @Override
    public Node getNextSibling() {
        if (this._parent == null) {
            return null;
        }
        File parent = (File)((AbstractWrappingAmetysElement)this._parent).getWrappedObject();
        File[] children = parent.listFiles();
        boolean isNext = false;
        File nextSibling = null;
        int i = 0;
        while (nextSibling == null && i < children.length) {
            File child = children[i++];
            if (isNext) {
                nextSibling = child;
                continue;
            }
            if (!((File)this._object).getAbsolutePath().equals(child.getAbsolutePath())) continue;
            isNext = true;
        }
        return nextSibling == null ? null : new FileElement(nextSibling, (FileElement)this._parent);
    }
}

