/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.authentication;

import java.util.Map;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.commons.lang3.StringUtils;

public class RemoteUserCredentialProvider
extends AbstractCredentialProvider
implements NonBlockingCredentialProvider,
Contextualizable {
    private static final String __PARAM_REALM = "runtime.authentication.remote.realm";
    private static final String __PARAM_HEADER_NAME = "runtime.authentication.remote.header.name";
    protected String _realm;
    protected String _headerName;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) {
        super.init(id, cpModelId, paramValues, label);
        this._realm = (String)paramValues.get(__PARAM_REALM);
        this._headerName = (String)paramValues.get(__PARAM_HEADER_NAME);
    }

    @Override
    public boolean nonBlockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        return true;
    }

    @Override
    public boolean nonBlockingGrantAnonymousRequest() {
        return false;
    }

    @Override
    public UserIdentity nonBlockingGetUserIdentity(Redirector redirector) throws Exception {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        String remoteLogin = ObjectModelHelper.getRequest((Map)objectModel).getHeader(this._headerName);
        if (remoteLogin == null) {
            this.getLogger().error("Remote User is null! Missing filter?");
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this._realm)) {
            int begin = remoteLogin.indexOf("\\");
            if (begin <= 0) {
                this.getLogger().error("Remote User '{}' does not match realm\\login", (Object)remoteLogin);
                return null;
            }
            String userLogin = remoteLogin.substring(begin + 1);
            String userRealm = remoteLogin.substring(0, begin);
            if (!this._realm.equals(userRealm)) {
                this.getLogger().error("Remote user realm '{}' does not match application realm '{}'", (Object)userRealm, (Object)this._realm);
                return null;
            }
            return new UserIdentity(userLogin, null);
        }
        return new UserIdentity(remoteLogin, null);
    }

    @Override
    public void nonBlockingUserNotAllowed(Redirector redirector) throws Exception {
    }

    @Override
    public void nonBlockingUserAllowed(UserIdentity userIdentity) {
    }
}

