/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.checker;

import java.util.List;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class SendMailChecker
implements ItemChecker,
Configurable {
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] config = configuration.getChild("linked-params").getChildren();
        if (config.length != 7) {
            throw new ConfigurationException("The MailConnectionChecker should have 5 linked params in the right order: host, port, security.protocol, user, password, fromEmail, toEmail");
        }
    }

    @Override
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        String host = values.get(0);
        String portAsString = values.get(1);
        String protocol = values.get(2);
        String user = values.get(3);
        String password = values.get(4);
        String sender = values.get(5);
        String recipient = values.get(6);
        long port = Integer.parseInt(portAsString);
        try {
            SendMailHelper.sendMail("[Ametys] Test email", null, "You are receving this email because a send mail test was launch on the Ametys server at: '', and the following email address is set as the administrator address :'" + recipient + "'.", null, recipient, sender, null, null, false, false, host, port, protocol, user, password, false);
        }
        catch (Exception e) {
            throw new ItemCheckerTestFailureException(e.getMessage(), e);
        }
    }
}

