/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.datasource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ametys.core.datasource.dbtype.SQLDatabaseType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public class StaticSQLDatabaseType
extends AbstractLogEnabled
implements Configurable,
SQLDatabaseType,
PluginAware {
    protected String _id;
    protected I18nizableText _label;
    protected String _driver;
    protected String _template;
    protected String _pluginName;
    protected String _validationQuery;
    protected I18nizableText _driverNotFoundMessage;
    protected String _languageEscapeTableNameTemplate;
    protected String _languageLimitQueryTemplate;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuring database type with id '" + this._id + "'");
        }
        this._label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + this._pluginName);
        this._driver = configuration.getChild("driver").getValue();
        this._driverNotFoundMessage = I18nizableText.parseI18nizableText(configuration.getChild("driver-not-found-message"), "plugin." + this._pluginName);
        this._template = configuration.getChild("template").getValue("");
        this._validationQuery = configuration.getChild("validation-query").getValue("SELECT 1");
        this._languageEscapeTableNameTemplate = configuration.getChild("language").getChild("escape-table-name").getValue("{tableName}");
        this._languageLimitQueryTemplate = configuration.getChild("language").getChild("limit-query").getValue("{query} LIMIT {limit} OFFSET {offset}");
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public String getDriver() {
        return this._driver;
    }

    @Override
    public String getTemplate() {
        return this._template;
    }

    @Override
    public String getValidationQuery() {
        return this._validationQuery;
    }

    @Override
    public I18nizableText getDriverNotFoundMessage() {
        return this._driverNotFoundMessage;
    }

    @Override
    public String languageEscapeTableName(String tableNameToEscape) {
        return StringUtils.replace((String)this._languageEscapeTableNameTemplate, (String)"{tableName}", (String)tableNameToEscape);
    }

    @Override
    public String languageLimitQuery(String queryToLimit, String limit, String offset) {
        return StringUtils.replace((String)StringUtils.replace((String)StringUtils.replace((String)this._languageLimitQueryTemplate, (String)"{query}", (String)queryToLimit), (String)"{limit}", (String)limit), (String)"{offset}", (String)offset);
    }

    @Override
    public InputStream getBlob(ResultSet resultSet, String columnName) throws SQLException {
        Blob commentBlob = resultSet.getBlob(columnName);
        return commentBlob != null ? commentBlob.getBinaryStream() : null;
    }

    @Override
    public InputStream getBlob(ResultSet resultSet, int pos) throws SQLException {
        Blob commentBlob = resultSet.getBlob(pos);
        return commentBlob != null ? commentBlob.getBinaryStream() : null;
    }

    @Override
    public void setBlob(PreparedStatement statement, int pos, String blob) throws SQLException, UnsupportedEncodingException {
        if (blob == null) {
            statement.setNull(pos, 2004);
        } else {
            byte[] bytes = blob.getBytes("UTF-8");
            this.setBlob(statement, pos, bytes);
        }
    }

    @Override
    public void setBlob(PreparedStatement statement, int pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            statement.setNull(pos, 2004);
        } else {
            statement.setBlob(pos, new ByteArrayInputStream(bytes));
        }
    }

    @Override
    public void setBlob(PreparedStatement statement, int pos, InputStream is, long length) throws SQLException {
        if (is == null) {
            statement.setNull(pos, 2004);
        } else {
            statement.setBlob(pos, is);
        }
    }
}

