/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.right.RightContextConvertor;
import org.ametys.core.right.RightContextConvertorExtensionPoint;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;

public class WorkspaceRightContextConvertor
implements RightContextConvertor,
Contextualizable,
Serviceable {
    protected Context _context;
    protected RightContextConvertorExtensionPoint _rightContextConvertorEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._rightContextConvertorEP = (RightContextConvertorExtensionPoint)manager.lookup(RightContextConvertorExtensionPoint.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public Set<Object> convert(Object object) {
        String context;
        HashSet<Object> objects = new HashSet<Object>();
        if (object instanceof String && (context = (String)object).indexOf("${WorkspaceName}") != -1) {
            Request request = ContextHelper.getRequest((Context)this._context);
            String currentWorkspace = (String)request.getAttribute("workspaceName");
            if (StringUtils.isBlank((String)currentWorkspace)) {
                currentWorkspace = "admin";
            }
            String resolvedContext = StringUtils.replace((String)context, (String)"${WorkspaceName}", (String)currentWorkspace);
            objects.addAll(this._rightContextConvertorEP.getExtensionsIds().stream().map(this._rightContextConvertorEP::getExtension).flatMap(convertor -> convertor.convert(resolvedContext).stream()).collect(Collectors.toSet()));
            objects.add(resolvedContext);
        }
        return objects;
    }
}

