/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.directory;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.commons.lang3.StringUtils;

public class StaticUserDirectory
extends AbstractLogEnabled
implements UserDirectory,
Component {
    private static final String __PARAM_USERS = "runtime.users.static.users";
    private Map<String, User> _staticUsers;
    private String _udModelId;
    private Map<String, Object> _paramValues;
    private String _populationId;
    private String _label;
    private String _id;
    private boolean _grantAllCredentials = true;

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) {
        this._id = id;
        this._udModelId = udModelId;
        this._staticUsers = new HashMap<String, User>();
        this._label = label;
        this._paramValues = paramValues;
        String usersAsText = (String)paramValues.get(__PARAM_USERS);
        for (String userLine : usersAsText.split("\\n")) {
            User user = this._createUser(userLine);
            this._staticUsers.put(user.getIdentity().getLogin(), user);
        }
    }

    @Override
    public void setPopulationId(String populationId) {
        this._populationId = populationId;
    }

    @Override
    public String getPopulationId() {
        return this._populationId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    public void setGrantAllCredentials(boolean grantAllCredentials) {
        this._grantAllCredentials = grantAllCredentials;
    }

    @Override
    public String getUserDirectoryModelId() {
        return this._udModelId;
    }

    @Override
    public Collection<User> getUsers() {
        return this._staticUsers.values();
    }

    @Override
    public List<User> getUsers(int count, int offset, Map<String, Object> parameters) {
        String pattern = (String)StringUtils.defaultIfEmpty((CharSequence)((String)parameters.get("pattern")), (CharSequence)"");
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        List result = this._staticUsers.values().stream().filter(user -> this._isLike((User)user, pattern)).collect(Collectors.toList());
        int toIndex = boundedOffset + boundedCount;
        toIndex = toIndex > result.size() ? result.size() : toIndex;
        return result.subList(boundedOffset, toIndex);
    }

    @Override
    public User getUser(String login) {
        return this._staticUsers.get(login);
    }

    @Override
    public User getUserByEmail(String email) throws NotUniqueUserException {
        List users = this._staticUsers.values().stream().filter(user -> email.equals(user.getEmail())).collect(Collectors.toList());
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        if (users.isEmpty()) {
            return null;
        }
        throw new NotUniqueUserException("Find " + users.size() + " users matching the email " + email);
    }

    @Override
    public boolean checkCredentials(String login, String password) {
        return this._grantAllCredentials && this._staticUsers.containsKey(login);
    }

    private User _createUser(String userLine) {
        String[] userInfo = userLine.split(":");
        String login = null;
        String lastName = null;
        String firstName = null;
        String email = null;
        switch (userInfo.length) {
            case 4: {
                email = userInfo[3];
            }
            case 3: {
                firstName = userInfo[2];
            }
            case 2: {
                lastName = userInfo[1];
                login = userInfo[0];
                break;
            }
            case 1: {
                lastName = login = userInfo[0];
                break;
            }
            default: {
                this.getLogger().error("Error while reading StaticUserDirectory users, cannot create an user with the data from line {}", (Object)userLine);
            }
        }
        return new User(new UserIdentity(login, this._populationId), lastName, firstName, email, this);
    }

    private boolean _isLike(User user, String pattern) {
        String modifiedPattern = StringUtils.stripAccents((String)pattern);
        return StringUtils.containsIgnoreCase((CharSequence)StringUtils.stripAccents((String)user.getIdentity().getLogin()), (CharSequence)modifiedPattern) || StringUtils.containsIgnoreCase((CharSequence)StringUtils.stripAccents((String)user.getFirstName()), (CharSequence)modifiedPattern) || StringUtils.containsIgnoreCase((CharSequence)StringUtils.stripAccents((String)user.getLastName()), (CharSequence)modifiedPattern);
    }
}

