/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferenceProvider;
import org.ametys.runtime.parameter.AbstractParameterParser;
import org.ametys.runtime.parameter.Enumerator;
import org.ametys.runtime.parameter.ParameterHelper;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class StaticUserPreferenceProvider
extends AbstractLogEnabled
implements UserPreferenceProvider,
Contextualizable,
Serviceable,
Configurable,
PluginAware,
Disposable {
    protected Map<String, UserPreference> _preferences;
    protected ThreadSafeComponentManager<Validator> _validatorManager;
    protected ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    protected ServiceManager _serviceManager;
    protected Context _context;
    protected String _pluginName;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._serviceManager = manager;
    }

    public void dispose() {
        this._validatorManager.dispose();
        this._validatorManager = null;
        this._enumeratorManager.dispose();
        this._enumeratorManager = null;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] prefConfigurations;
        this._validatorManager = new ThreadSafeComponentManager();
        this._validatorManager.setLogger(this.getLogger());
        this._validatorManager.contextualize(this._context);
        this._validatorManager.service(this._serviceManager);
        this._enumeratorManager = new ThreadSafeComponentManager();
        this._enumeratorManager.setLogger(this.getLogger());
        this._enumeratorManager.contextualize(this._context);
        this._enumeratorManager.service(this._serviceManager);
        UserPreferenceParser prefParser = new UserPreferenceParser(this._enumeratorManager, this._validatorManager);
        this._preferences = new HashMap<String, UserPreference>();
        for (Configuration prefConfiguration : prefConfigurations = configuration.getChildren("param")) {
            this.configurePreference(prefParser, prefConfiguration);
        }
        try {
            prefParser.lookupComponents();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to lookup parameter local components", configuration, (Throwable)e);
        }
    }

    protected void configurePreference(UserPreferenceParser prefParser, Configuration configuration) throws ConfigurationException {
        UserPreference preference = (UserPreference)prefParser.parseParameter(this._serviceManager, this._pluginName, configuration);
        String id = preference.getId();
        if (this._preferences.containsKey(id)) {
            throw new ConfigurationException("The user preference '" + id + "' is already declared. Preference IDs must be unique.", configuration);
        }
        this._preferences.put(id, preference);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("User preference added: " + id);
        }
    }

    @Override
    public Collection<UserPreference> getPreferences(Map<String, String> context) {
        HashSet<UserPreference> userPrefs = new HashSet<UserPreference>();
        String currentWorkspace = context.get("workspace");
        for (UserPreference userPref : this._preferences.values()) {
            Pattern workspace = ((StaticUserPreference)userPref).getWorkspace();
            if (!StringUtils.isBlank((CharSequence)currentWorkspace) && workspace != null && !workspace.matcher(currentWorkspace).matches()) continue;
            userPrefs.add(userPref);
        }
        return userPrefs;
    }

    class UserPreferenceParser
    extends AbstractParameterParser<UserPreference, ParameterHelper.ParameterType> {
        public UserPreferenceParser(ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
            super(enumeratorManager, validatorManager);
        }

        @Override
        protected UserPreference _createParameter(Configuration parameterConfig) throws ConfigurationException {
            return new StaticUserPreference();
        }

        @Override
        protected String _parseId(Configuration parameterConfig) throws ConfigurationException {
            return parameterConfig.getAttribute("id");
        }

        @Override
        protected ParameterHelper.ParameterType _parseType(Configuration parameterConfig) throws ConfigurationException {
            try {
                return ParameterHelper.ParameterType.valueOf(parameterConfig.getAttribute("type").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Invalid parameter type", parameterConfig, (Throwable)e);
            }
        }

        @Override
        protected Object _parseDefaultValue(Configuration parameterConfig, UserPreference preference) {
            String defaultValue = parameterConfig.getChild("default-value").getValue(null);
            return ParameterHelper.castValue(defaultValue, (ParameterHelper.ParameterType)((Object)preference.getType()));
        }

        protected Pattern _parseWorkspace(Configuration configuration) throws ConfigurationException {
            String value = configuration.getChild("workspace").getValue(null);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return Pattern.compile(value);
            }
            return null;
        }

        @Override
        protected void _additionalParsing(ServiceManager manager, String pluginName, Configuration preferenceConfig, String parameterId, UserPreference preference) throws ConfigurationException {
            super._additionalParsing(manager, pluginName, preferenceConfig, parameterId, preference);
            boolean multiple = preferenceConfig.getAttributeAsBoolean("multiple", false);
            int order = preferenceConfig.getChild("order").getValueAsInteger(1000);
            String managerRole = preferenceConfig.getChild("manager-role").getValue(null);
            boolean privateStatus = preferenceConfig.getAttributeAsBoolean("private", false);
            Pattern workspace = this._parseWorkspace(preferenceConfig);
            preference.setId(parameterId);
            preference.setDisplayGroup(this._parseI18nizableText(preferenceConfig, pluginName, "group"));
            preference.setMultiple(multiple);
            preference.setManagerRole(managerRole);
            preference.setOrder(order);
            preference.setPrivate(privateStatus);
            ((StaticUserPreference)preference).setWorkspace(workspace);
        }
    }

    class StaticUserPreference
    extends UserPreference {
        protected Pattern _workspace;

        StaticUserPreference() {
        }

        public void setWorkspace(Pattern workspace) {
            this._workspace = workspace;
        }

        public Pattern getWorkspace() {
            return this._workspace;
        }
    }
}

