/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.util.I18nUtils;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetRightsAction
extends ServiceableAction {
    private RightsExtensionPoint _rights;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager m) throws ServiceException {
        super.service(m);
        this._rights = (RightsExtensionPoint)m.lookup(RightsExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)m.lookup(I18nUtils.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        HashMap result = new HashMap();
        ArrayList<Map<String, Object>> rights = new ArrayList<Map<String, Object>>();
        Set<String> rightIds = this._rights.getExtensionsIds();
        String rightQuery = (String)jsParameters.get("query");
        if (StringUtils.isEmpty((CharSequence)rightQuery)) {
            for (String rightId : rightIds) {
                rights.add(this._rights.getExtension(rightId).toJSON());
            }
        } else {
            rightQuery = StringUtils.stripAccents((String)rightQuery.toLowerCase());
            for (String rightId : rightIds) {
                Right right = this._rights.getExtension(rightId);
                String translatedLabel = this._i18nUtils.translate(right.getLabel());
                String translatedDescription = this._i18nUtils.translate(right.getDescription());
                String rightLabel = null;
                if (translatedLabel != null) {
                    rightLabel = StringUtils.stripAccents((String)translatedLabel.toLowerCase());
                }
                String rightDescription = null;
                if (translatedDescription != null) {
                    rightDescription = StringUtils.stripAccents((String)translatedDescription.toLowerCase());
                }
                if ((rightLabel == null || !rightLabel.contains(rightQuery)) && (rightDescription == null || !rightDescription.contains(rightQuery))) continue;
                rights.add(right.toJSON());
            }
        }
        result.put("rights", rights);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

