/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.core.datasource.dbtype.SQLDatabaseType;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.schedule.AmetysJob;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.schedule.RunnableExtensionPoint;
import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.SchedulableExtensionPoint;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.impl.schedule.DefaultRunnable;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.utils.Key;

public class Scheduler
extends AbstractLogEnabled
implements Component,
Initializable,
Disposable,
Serviceable,
Contextualizable {
    public static final String ROLE = Scheduler.class.getName();
    public static final String JOB_GROUP = "runtime.job";
    public static final String TRIGGER_GROUP = "runtime.trigger";
    public static final String KEY_SCHEDULABLE_ID = "schedulableId";
    public static final String KEY_RUNNABLE_ID = "id";
    public static final String KEY_RUNNABLE_LABEL = "label";
    public static final String KEY_RUNNABLE_DESCRIPTION = "description";
    public static final String KEY_RUNNABLE_FIRE_PROCESS = "fireProcess";
    public static final String KEY_RUNNABLE_STARTUP_COMPLETED = "runAtStartupCompleted";
    public static final String KEY_RUNNABLE_CRON = "cron";
    public static final String KEY_RUNNABLE_REMOVABLE = "removable";
    public static final String KEY_RUNNABLE_MODIFIABLE = "modifiable";
    public static final String KEY_RUNNABLE_DEACTIVATABLE = "deactivatable";
    public static final String KEY_RUNNABLE_VOLATILE = "volatile";
    public static final String KEY_RUNNABLE_USERIDENTITY = "userIdentity";
    public static final String PARAM_VALUES_PREFIX = "parameterValues#";
    public static final String DATASOURCE_CONFIG_NAME = "runtime.scheduler.datasource";
    private static final String __QUARTZ_CONFIG_FILE_NAME = "quartz.properties";
    private static final String __RIGHT_SCHEDULER = "CORE_Rights_TaskScheduler";
    protected ServiceManager _manager;
    protected Context _context;
    protected RunnableExtensionPoint _runnableEP;
    protected SchedulableExtensionPoint _schedulableEP;
    protected org.quartz.Scheduler _scheduler;
    protected SQLDataSourceManager _sqlDataSourceManager;
    protected SourceResolver _sourceResolver;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;
    protected SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeEP;
    protected UserManager _userManager;
    protected UserHelper _userHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._runnableEP = (RunnableExtensionPoint)manager.lookup(RunnableExtensionPoint.ROLE);
        this._schedulableEP = (SchedulableExtensionPoint)manager.lookup(SchedulableExtensionPoint.ROLE);
        this._sqlDataSourceManager = (SQLDataSourceManager)manager.lookup(SQLDataSourceManager.ROLE);
        this._sqlDatabaseTypeEP = (SQLDatabaseTypeExtensionPoint)manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        manager.lookup(ConnectionHelper.ROLE);
    }

    public void initialize() throws Exception {
        String dsId = (String)Config.getInstance().getValue(DATASOURCE_CONFIG_NAME);
        this._checkAndCreateTables(dsId);
        Map<String, Object> dsParameters = this._sqlDataSourceManager.getDataSourceDefinition(dsId).getParameters();
        String url = (String)dsParameters.get("url");
        String user = (String)dsParameters.get("user");
        String password = (String)dsParameters.get("password");
        String dbtype = (String)dsParameters.get("dbtype");
        SQLDatabaseType sqlDbType = (SQLDatabaseType)this._sqlDatabaseTypeEP.getExtension(dbtype);
        String dbType = ConnectionHelper.getDatabaseType(url);
        String dsName = "quartzDb";
        Properties props = new Properties();
        props.load(Scheduler.class.getResourceAsStream(__QUARTZ_CONFIG_FILE_NAME));
        props.setProperty("org.quartz.jobStore.dataSource", dsName);
        props.setProperty("org.quartz.dataSource." + dsName + "." + "driver", sqlDbType.getDriver());
        props.setProperty("org.quartz.dataSource." + dsName + "." + "URL", url);
        props.setProperty("org.quartz.dataSource." + dsName + "." + "user", user);
        props.setProperty("org.quartz.dataSource." + dsName + "." + "password", password);
        props.setProperty("org.quartz.jobStore.driverDelegateClass", this._getDriverDelegateClass(dbType));
        StdSchedulerFactory factory = new StdSchedulerFactory(props);
        this._scheduler = factory.getScheduler();
        AmetysJob.initialize(this._manager, this._context);
    }

    private void _checkAndCreateTables(String dataSourceId) {
        try {
            SQLScriptHelper.createTableIfNotExists(dataSourceId, "QRTZ_JOB_DETAILS", "plugin:core://scripts/%s/quartz.sql", this._sourceResolver);
        }
        catch (Exception e) {
            String errorMsg = String.format("Error during SQL tables initialization for data source id: '%s'.", StringUtils.defaultString((String)dataSourceId));
            this.getLogger().error(errorMsg, (Throwable)e);
        }
    }

    private String _getDriverDelegateClass(String dbType) {
        switch (dbType) {
            case "hsqldb": {
                return "org.quartz.impl.jdbcjobstore.HSQLDBDelegate";
            }
            case "postgresql": {
                return "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
            }
        }
        return "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
    }

    public void start() throws SchedulerException {
        this._removeVolatileJobs();
        this._scheduleConfigurableJobs();
        this._triggerRunAtStartupJobs();
        this.getLogger().info("Start up the scheduler");
        this._scheduler.start();
    }

    public org.quartz.Scheduler getScheduler() {
        return this._scheduler;
    }

    private void _removeVolatileJobs() throws SchedulerException {
        for (JobKey jobKey : this.getJobs()) {
            JobDataMap jobDataMap = this._scheduler.getJobDetail(jobKey).getJobDataMap();
            if (!jobDataMap.getBoolean(KEY_RUNNABLE_VOLATILE)) continue;
            this._scheduler.deleteJob(jobKey);
        }
    }

    private void _scheduleConfigurableJobs() {
        try {
            for (String runnableId : this._runnableEP.getExtensionsIds()) {
                JobKey jobKey = new JobKey(runnableId, JOB_GROUP);
                if (this._scheduler.checkExists(jobKey)) {
                    this._scheduler.deleteJob(jobKey);
                }
                Runnable runnable = (Runnable)this._runnableEP.getExtension(runnableId);
                this.scheduleJob(runnable);
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error("An exception occured during the scheduling of configurable runnables", (Throwable)e);
        }
    }

    private void _triggerRunAtStartupJobs() throws SchedulerException {
        for (JobKey jobKey : this.getJobs()) {
            JobDataMap jobDataMap = this._scheduler.getJobDetail(jobKey).getJobDataMap();
            if (!Runnable.FireProcess.STARTUP.toString().equals(jobDataMap.getString(KEY_RUNNABLE_FIRE_PROCESS)) || jobDataMap.getBoolean(KEY_RUNNABLE_STARTUP_COMPLETED)) continue;
            this._scheduler.triggerJob(jobKey);
        }
    }

    public void scheduleJob(Runnable runnable) throws SchedulerException {
        String runnableId = runnable.getId();
        String schedulableId = runnable.getSchedulableId();
        JobDetail jobDetail = null;
        JobBuilder jobBuilder = JobBuilder.newJob(AmetysJob.class).withIdentity(runnableId, JOB_GROUP).usingJobData(KEY_SCHEDULABLE_ID, schedulableId).usingJobData(this._runnableToJobDataMap(runnable));
        Date firstTime = null;
        switch (runnable.getFireProcess()) {
            case NEVER: {
                jobDetail = jobBuilder.storeDurably().build();
                this._scheduler.addJob(jobDetail, true);
                this.getLogger().info("{} has been scheduled to never run", (Object)jobDetail.getKey());
                break;
            }
            case STARTUP: {
                jobDetail = jobBuilder.storeDurably().build();
                this._scheduler.addJob(jobDetail, true);
                this.getLogger().info("{} has been scheduled to run at next startup of the application", (Object)jobDetail.getKey());
                break;
            }
            case NOW: {
                jobDetail = jobBuilder.storeDurably().build();
                Trigger simpleTrigger = TriggerBuilder.newTrigger().withIdentity(runnableId, TRIGGER_GROUP).startNow().build();
                firstTime = this._scheduler.scheduleJob(jobDetail, simpleTrigger);
                this.getLogger().info("{} has been scheduled to run as soon as possible", (Object)jobDetail.getKey());
                break;
            }
            default: {
                jobDetail = jobBuilder.storeDurably().build();
                CronScheduleBuilder schedBuilder = CronScheduleBuilder.cronSchedule((String)runnable.getCronExpression());
                switch (runnable.getMisfirePolicy()) {
                    case IGNORE: {
                        schedBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                        break;
                    }
                    case FIRE_ONCE: {
                        schedBuilder.withMisfireHandlingInstructionFireAndProceed();
                        break;
                    }
                    default: {
                        schedBuilder.withMisfireHandlingInstructionDoNothing();
                    }
                }
                CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(runnableId, TRIGGER_GROUP).startNow().withSchedule((ScheduleBuilder)schedBuilder).build();
                firstTime = this._scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
                this.getLogger().info("{} has been scheduled to run at: {} and repeat based on expression: {}", new Object[]{jobDetail.getKey(), firstTime, cronTrigger.getCronExpression()});
            }
        }
    }

    private JobDataMap _runnableToJobDataMap(Runnable runnable) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(KEY_RUNNABLE_ID, runnable.getId());
        result.put(KEY_RUNNABLE_LABEL, I18nizableText.i18nizableTextToString(runnable.getLabel()));
        result.put(KEY_RUNNABLE_DESCRIPTION, I18nizableText.i18nizableTextToString(runnable.getDescription()));
        result.put(KEY_RUNNABLE_FIRE_PROCESS, runnable.getFireProcess().toString());
        result.put(KEY_RUNNABLE_CRON, runnable.getCronExpression());
        result.put(KEY_RUNNABLE_REMOVABLE, runnable.isRemovable());
        result.put(KEY_RUNNABLE_MODIFIABLE, runnable.isModifiable());
        result.put(KEY_RUNNABLE_DEACTIVATABLE, runnable.isDeactivatable());
        result.put(KEY_RUNNABLE_VOLATILE, runnable.isVolatile());
        result.put(KEY_RUNNABLE_USERIDENTITY, UserIdentity.userIdentityToString(runnable.getUserIdentity()));
        for (String paramId : runnable.getParameterValues().keySet()) {
            result.put(PARAM_VALUES_PREFIX + paramId, runnable.getParameterValues().get(paramId));
        }
        return new JobDataMap(result);
    }

    public Set<JobKey> getJobs() throws SchedulerException {
        return this._scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)JOB_GROUP));
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public List<Map<String, Object>> getTasksInformation(List<String> taskIds) throws SchedulerException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (JobKey jobKey : this.getJobs()) {
            String id = jobKey.getName();
            if (!taskIds.contains(id)) continue;
            HashMap<String, Object> task = new HashMap<String, Object>();
            JobDataMap jobDataMap = this._scheduler.getJobDetail(jobKey).getJobDataMap();
            task.put(KEY_RUNNABLE_ID, id);
            task.put(KEY_RUNNABLE_MODIFIABLE, jobDataMap.getBoolean(KEY_RUNNABLE_MODIFIABLE));
            task.put(KEY_RUNNABLE_REMOVABLE, jobDataMap.getBoolean(KEY_RUNNABLE_REMOVABLE));
            task.put(KEY_RUNNABLE_DEACTIVATABLE, jobDataMap.getBoolean(KEY_RUNNABLE_DEACTIVATABLE));
            result.add(task);
        }
        return result;
    }

    public List<Map<String, Object>> getTasksAsJson() throws Exception {
        List<JobKey> executingJobs = this._getExecutingJobs();
        return this.getJobs().stream().map(LambdaUtils.wrap(key -> this._jobToJson((JobKey)key, executingJobs))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<JobKey> _getExecutingJobs() throws SchedulerException {
        return this._scheduler.getCurrentlyExecutingJobs().stream().map(JobExecutionContext::getJobDetail).map(JobDetail::getKey).collect(Collectors.toList());
    }

    private Map<String, Object> _jobToJson(JobKey jobKey, List<JobKey> executingJobs) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JobDataMap jobDataMap = this._scheduler.getJobDetail(jobKey).getJobDataMap();
        String id = jobDataMap.getString(KEY_RUNNABLE_ID);
        result.put(KEY_RUNNABLE_ID, id);
        String schedulableId = jobDataMap.getString(KEY_SCHEDULABLE_ID);
        if (!this._schedulableEP.hasExtension(schedulableId)) {
            this.getLogger().warn("The Runnable '{}' is associated to a Schedulable that does not exist anymore ({}).", (Object)id, (Object)schedulableId);
            return null;
        }
        Schedulable schedulable = (Schedulable)this._schedulableEP.getExtension(schedulableId);
        result.put(KEY_RUNNABLE_LABEL, I18nizableText.stringToI18nizableText((String)jobDataMap.get((Object)KEY_RUNNABLE_LABEL)));
        result.put(KEY_RUNNABLE_DESCRIPTION, I18nizableText.stringToI18nizableText((String)jobDataMap.get((Object)KEY_RUNNABLE_DESCRIPTION)));
        String fireProcess = jobDataMap.getString(KEY_RUNNABLE_FIRE_PROCESS);
        result.put(KEY_RUNNABLE_FIRE_PROCESS, fireProcess);
        result.put("launchUser", Optional.ofNullable(jobDataMap.getString(KEY_RUNNABLE_USERIDENTITY)).map(UserIdentity::stringToUserIdentity).map(this._userManager::getUser).map(u -> this._userHelper.user2json((User)u, true)).orElse(Collections.EMPTY_MAP));
        result.put(KEY_RUNNABLE_REMOVABLE, jobDataMap.getBoolean(KEY_RUNNABLE_REMOVABLE));
        result.put(KEY_RUNNABLE_MODIFIABLE, jobDataMap.getBoolean(KEY_RUNNABLE_MODIFIABLE));
        result.put(KEY_RUNNABLE_DEACTIVATABLE, jobDataMap.getBoolean(KEY_RUNNABLE_DEACTIVATABLE));
        result.put("lastDuration", jobDataMap.get((Object)"duration"));
        result.put("success", jobDataMap.get((Object)"success"));
        result.put("running", this._isRunningJob(jobKey, executingJobs));
        result.put("schedulable", this._schedulableToJson(schedulable));
        Long previousFireTimeMillis = null;
        String cronExpression = null;
        TriggerKey triggerKey = new TriggerKey(jobKey.getName(), TRIGGER_GROUP);
        if (this._scheduler.checkExists(triggerKey)) {
            Trigger trigger = this._scheduler.getTrigger(triggerKey);
            this._triggerToJson(trigger, result);
            if (trigger instanceof CronTrigger) {
                cronExpression = ((CronTrigger)trigger).getCronExpression();
            }
            result.put("completed", false);
            Date previousFireTime = trigger.getPreviousFireTime();
            if (previousFireTime != null) {
                previousFireTimeMillis = previousFireTime.getTime();
            }
        } else {
            result.put("enabled", true);
            result.put("completed", !Runnable.FireProcess.STARTUP.toString().equals(fireProcess) || jobDataMap.getBoolean(KEY_RUNNABLE_STARTUP_COMPLETED));
        }
        if (cronExpression == null && Runnable.FireProcess.CRON.toString().equals(fireProcess)) {
            cronExpression = jobDataMap.getString(KEY_RUNNABLE_CRON);
        }
        result.put("cronExpression", cronExpression);
        if (previousFireTimeMillis == null && jobDataMap.containsKey((Object)"previousFireTime")) {
            previousFireTimeMillis = (Long)jobDataMap.get((Object)"previousFireTime");
        }
        result.put("previousFireTime", previousFireTimeMillis);
        return result;
    }

    private boolean _isRunningJob(JobKey jobKey, List<JobKey> executingJobs) {
        return executingJobs.contains(jobKey);
    }

    private void _triggerToJson(Trigger trigger, Map<String, Object> result) throws Exception {
        result.put("enabled", !Trigger.TriggerState.PAUSED.equals((Object)this._scheduler.getTriggerState(trigger.getKey())));
        result.put("nextFireTime", trigger.getNextFireTime());
    }

    private Map<String, Object> _schedulableToJson(Schedulable schedulable) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(KEY_RUNNABLE_ID, schedulable.getId());
        result.put(KEY_RUNNABLE_LABEL, schedulable.getLabel());
        result.put(KEY_RUNNABLE_DESCRIPTION, schedulable.getDescription());
        result.put("iconGlyph", schedulable.getIconGlyph());
        result.put("iconSmall", schedulable.getIconSmall());
        result.put("iconMedium", schedulable.getIconMedium());
        result.put("iconLarge", schedulable.getIconLarge());
        result.put("private", schedulable.isPrivate());
        LinkedHashMap<String, Map<String, Object>> params = new LinkedHashMap<String, Map<String, Object>>();
        for (String paramId : schedulable.getParameters().keySet()) {
            params.put(schedulable.getId() + "$" + paramId, schedulable.getParameters().get(paramId).toJSON());
        }
        result.put("parameters", params);
        return result;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> getEditionConfiguration() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList fireProcesses = new ArrayList();
        for (Runnable.FireProcess fireProcessVal : Runnable.FireProcess.values()) {
            if (fireProcessVal.equals((Object)Runnable.FireProcess.NEVER)) continue;
            LinkedHashMap<String, Object> fireProcess = new LinkedHashMap<String, Object>();
            fireProcess.put("value", fireProcessVal.toString());
            String i18nKey = "PLUGINS_CORE_UI_TASKS_DIALOG_FIRE_PROCESS_OPTION_" + fireProcessVal.toString() + "_LABEL";
            fireProcess.put(KEY_RUNNABLE_LABEL, new I18nizableText("plugin.core-ui", i18nKey));
            fireProcesses.add(fireProcess);
        }
        result.put("fireProcesses", fireProcesses);
        ArrayList<Map<String, Object>> schedulables = new ArrayList<Map<String, Object>>();
        for (String schedulableId : this._schedulableEP.getExtensionsIds()) {
            Schedulable schedulable = (Schedulable)this._schedulableEP.getExtension(schedulableId);
            if (schedulable.isPrivate()) continue;
            schedulables.add(this._schedulableToJson(schedulable));
        }
        result.put("schedulables", schedulables);
        return result;
    }

    @Callable
    public Map<String, Object> getParameters(String schedulableId) throws Exception {
        Schedulable schedulable = (Schedulable)this._schedulableEP.getExtension(schedulableId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        for (String paramId : schedulable.getParameters().keySet()) {
            params.put(schedulable.getId() + "$" + paramId, schedulable.getParameters().get(paramId).toJSON());
        }
        return params;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> getParameterValues(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            JobDetail jobDetail = this._scheduler.getJobDetail(new JobKey(id, JOB_GROUP));
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            result.put(KEY_RUNNABLE_ID, id);
            result.put(KEY_RUNNABLE_LABEL, I18nizableText.stringToI18nizableText((String)jobDataMap.get((Object)KEY_RUNNABLE_LABEL)));
            result.put(KEY_RUNNABLE_DESCRIPTION, I18nizableText.stringToI18nizableText((String)jobDataMap.get((Object)KEY_RUNNABLE_DESCRIPTION)));
            result.put(KEY_RUNNABLE_FIRE_PROCESS, jobDataMap.getString(KEY_RUNNABLE_FIRE_PROCESS));
            result.put(KEY_RUNNABLE_CRON, jobDataMap.getString(KEY_RUNNABLE_CRON));
            String schedulableId = jobDataMap.getString(KEY_SCHEDULABLE_ID);
            result.put(KEY_SCHEDULABLE_ID, schedulableId);
            result.put("launchUser", jobDataMap.getString(KEY_RUNNABLE_USERIDENTITY));
            HashMap<String, Object> params = new HashMap<String, Object>();
            result.put("params", params);
            for (String param : jobDataMap.keySet()) {
                if (!param.startsWith(PARAM_VALUES_PREFIX)) continue;
                params.put(schedulableId + "$" + param.substring(PARAM_VALUES_PREFIX.length()), jobDataMap.get((Object)param));
            }
            return result;
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to retrieve the parameter values of the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
            return result;
        }
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> isModifiable(String id) throws SchedulerException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JobDetail jobDetail = this._scheduler.getJobDetail(new JobKey(id, JOB_GROUP));
        if (jobDetail == null) {
            result.put("error", "not-found");
            return result;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        result.put(KEY_RUNNABLE_MODIFIABLE, jobDataMap.getBoolean(KEY_RUNNABLE_MODIFIABLE));
        return result;
    }

    @Callable
    public Map<String, Object> add(String label, String description, String fireProcess, String cron, String schedulableId, Map<String, String> params) throws SchedulerException {
        Request request = ContextHelper.getRequest((Context)this._context);
        String workspaceName = (String)request.getAttribute("workspaceName");
        Map<String, Object> taskUser = null;
        if (!workspaceName.equals("admin") && (taskUser = this._userHelper.user2json(this._currentUserProvider.getUser())) == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "invalid-schedulable");
            return result;
        }
        return this.add(label, description, fireProcess, cron, schedulableId, this._userHelper.user2json(this._currentUserProvider.getUser()), params);
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> add(String label, String description, String fireProcess, String cron, String schedulableId, Map<String, Object> launchUser, Map<String, String> params) throws SchedulerException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this._schedulableEP.getExtension(schedulableId) == null) {
            result.put("error", "invalid-schedulable");
            return result;
        }
        if (((Schedulable)this._schedulableEP.getExtension(schedulableId)).isPrivate()) {
            result.put("error", "private");
            return result;
        }
        String id = this._generateUniqueId(label);
        return this._edit(id, label, description, Runnable.FireProcess.valueOf(fireProcess.toUpperCase()), cron, schedulableId, false, launchUser, params);
    }

    private String _generateUniqueId(String label) throws SchedulerException {
        String value = label.toLowerCase().trim().replaceAll("[\\W_]", "-").replaceAll("-+", "-").replaceAll("^-", "");
        int i = 2;
        String suffixedValue = value;
        while (this._scheduler.checkExists(new JobKey(suffixedValue, JOB_GROUP))) {
            suffixedValue = value + i;
            ++i;
        }
        return suffixedValue;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> edit(String id, String label, String description, String fireProcess, String cron, Map<String, Object> launchUser, Map<String, String> params) throws SchedulerException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JobDetail jobDetail = null;
        JobKey jobKey = new JobKey(id, JOB_GROUP);
        jobDetail = this._scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            result.put("error", "not-found");
            return result;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        boolean isModifiable = jobDataMap.getBoolean(KEY_RUNNABLE_MODIFIABLE);
        if (!isModifiable) {
            result.put("error", "no-modifiable");
            return result;
        }
        if (!this._scheduler.deleteJob(jobKey)) {
            result.put("error", "not-found");
            return result;
        }
        String schedulableId = jobDataMap.getString(KEY_SCHEDULABLE_ID);
        boolean isVolatile = jobDataMap.getBoolean(KEY_RUNNABLE_VOLATILE);
        return this._edit(id, label, description, Runnable.FireProcess.valueOf(fireProcess.toUpperCase()), cron, schedulableId, isVolatile, launchUser, params);
    }

    private Map<String, Object> _edit(String id, String label, String description, Runnable.FireProcess fireProcess, String cron, String schedulableId, boolean isVolatile, Map<String, Object> launchUser, Map<String, String> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> typedParams = this._getTypedParams(params, schedulableId);
        boolean deactivatable = !Runnable.FireProcess.STARTUP.equals((Object)fireProcess);
        UserIdentity userIdentity = this._userHelper.json2userIdentity(launchUser);
        DefaultRunnable runnable = new DefaultRunnable(id, new I18nizableText(label), new I18nizableText(description), fireProcess, cron, schedulableId, true, true, deactivatable, null, isVolatile, userIdentity, typedParams);
        try {
            this.scheduleJob(runnable);
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to add/edit the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
            return result;
        }
        result.put(KEY_RUNNABLE_ID, id);
        return result;
    }

    private Map<String, Object> _getTypedParams(Map<String, String> params, String schedulableId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, ElementDefinition> declaredParams = ((Schedulable)this._schedulableEP.getExtension(schedulableId)).getParameters();
        for (String nameWithPrefix : params.keySet()) {
            String[] splitStr = nameWithPrefix.split("\\$", 2);
            String prefix = splitStr[0];
            String paramName = splitStr[1];
            if (prefix.equals(schedulableId) && declaredParams.containsKey(paramName)) {
                String originalValue = params.get(nameWithPrefix);
                ElementDefinition definition = declaredParams.get(paramName);
                ElementType type = definition.getType();
                Object typedValue = type.castValue(originalValue);
                result.put(paramName, typedValue);
                continue;
            }
            if (!prefix.equals(schedulableId)) continue;
            this.getLogger().warn("The parameter {} is not declared in schedulable {}. It will be ignored", (Object)paramName, (Object)schedulableId);
        }
        return result;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> remove(String id) throws SchedulerException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JobKey jobKey = new JobKey(id, JOB_GROUP);
        JobDetail jobDetail = null;
        try {
            jobDetail = this._scheduler.getJobDetail(jobKey);
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to remove the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
            return result;
        }
        if (jobDetail == null) {
            result.put("error", "not-found");
            return result;
        }
        if (this._isRunningJob(jobKey, this._getExecutingJobs())) {
            result.put("error", "is-running");
            return result;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        boolean isRemovable = jobDataMap.getBoolean(KEY_RUNNABLE_REMOVABLE);
        if (!isRemovable) {
            result.put("error", "no-removable");
            return result;
        }
        try {
            if (this._scheduler.deleteJob(jobKey)) {
                result.put(KEY_RUNNABLE_ID, id);
                return result;
            }
            result.put("error", "no-delete");
            return result;
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to remove the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
            return result;
        }
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> enable(String id, boolean enabled) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JobKey jobKey = new JobKey(id, JOB_GROUP);
        JobDetail jobDetail = null;
        try {
            jobDetail = this._scheduler.getJobDetail(jobKey);
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to enable/disable the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
            return result;
        }
        if (jobDetail == null) {
            result.put("error", "not-found");
            return result;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        boolean isDeactivatable = jobDataMap.getBoolean(KEY_RUNNABLE_DEACTIVATABLE);
        if (!isDeactivatable) {
            result.put("error", "no-deactivatable");
            return result;
        }
        try {
            if (enabled) {
                this._scheduler.resumeJob(jobKey);
            } else {
                this._scheduler.pauseJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to enable/disable the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
            return result;
        }
        result.put(KEY_RUNNABLE_ID, id);
        return result;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public List<Map<String, Object>> removeCompletedTasks() throws SchedulerException {
        ArrayList<Map<String, Object>> targets = new ArrayList<Map<String, Object>>();
        ArrayList<JobKey> jobsToRemove = new ArrayList<JobKey>();
        for (JobKey jobKey : this.getJobs()) {
            JobDetail jobDetail = this._scheduler.getJobDetail(jobKey);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            if ((Runnable.FireProcess.STARTUP.toString().equals(jobDataMap.getString(KEY_RUNNABLE_FIRE_PROCESS)) || this._scheduler.checkExists(new TriggerKey(jobKey.getName(), TRIGGER_GROUP))) && (!Runnable.FireProcess.STARTUP.toString().equals(jobDataMap.getString(KEY_RUNNABLE_FIRE_PROCESS)) || !jobDataMap.getBoolean(KEY_RUNNABLE_STARTUP_COMPLETED))) continue;
            jobsToRemove.add(jobKey);
        }
        targets.addAll(this.getTasksInformation(jobsToRemove.stream().map(Key::getName).collect(Collectors.toList())));
        for (JobKey jobKey : jobsToRemove) {
            this._scheduler.deleteJob(jobKey);
        }
        return targets;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> isEnabled(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Trigger.TriggerState state = this._scheduler.getTriggerState(new TriggerKey(id, TRIGGER_GROUP));
            if (state == null) {
                result.put("error", "not-found");
                return result;
            }
            result.put("enabled", !Trigger.TriggerState.PAUSED.equals((Object)state));
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to retrieve the enable state of the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
            return result;
        }
        return result;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public Map<String, Object> isRunning(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("running", this._isRunningJob(new JobKey(id, JOB_GROUP), this._getExecutingJobs()));
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to retrieve the running state of the task " + id, (Throwable)e);
            result.put("error", "scheduler-error");
        }
        return result;
    }

    @Callable(right="CORE_Rights_TaskScheduler", context="/admin")
    public List<Map<String, Object>> getSchedulables() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String schedulableId : this._schedulableEP.getExtensionsIds()) {
            Schedulable schedulable = (Schedulable)this._schedulableEP.getExtension(schedulableId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(KEY_RUNNABLE_ID, schedulable.getId());
            map.put("text", schedulable.getLabel());
            result.add(map);
        }
        return result;
    }

    public void dispose() {
        try {
            this._scheduler.shutdown();
            AmetysJob.dispose();
        }
        catch (SchedulerException e) {
            this.getLogger().error("Fail to shutdown scheduler", (Throwable)e);
        }
    }
}

