/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.about;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.version.Version;
import org.ametys.core.version.VersionsHandler;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;

public class AboutInfoProvider
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = AboutInfoProvider.class.getName();
    private static final String NOTICE_FILE_PATH = "/NOTICE.txt";
    private static final String LOGO_FILE_PATH = "/app_logo.png";
    private VersionsHandler _versionsHandler;
    private Context _cocoonContext;

    public void service(ServiceManager manager) throws ServiceException {
        this._versionsHandler = (VersionsHandler)manager.lookup(VersionsHandler.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    @Callable
    public Map<String, Object> getInfo(String lang) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("applicationLogo", this.getApplicationLogo());
        result.put("applicationName", this.getApplicationName(lang));
        result.put("versions", this.getVersions());
        result.put("licenseText", this.getLicenseText());
        return result;
    }

    @Callable
    public String getApplicationLogo() {
        String path = this._cocoonContext.getRealPath(LOGO_FILE_PATH);
        File imgFile = new File(path);
        if (imgFile.exists() && imgFile.isFile()) {
            return this._cocoonContext.getRealPath(LOGO_FILE_PATH);
        }
        return null;
    }

    @Callable
    public String getApplicationName(String lang) {
        return I18nUtils.getInstance().translate(new I18nizableText("application", "APPLICATION_PRODUCT_LABEL"), lang);
    }

    @Callable
    public List<Map<String, Object>> getVersions() {
        ArrayList<Map<String, Object>> versions = new ArrayList<Map<String, Object>>();
        for (Version version : this._versionsHandler.getVersions()) {
            LinkedHashMap<String, String> versionInfos = new LinkedHashMap<String, String>();
            versionInfos.put("name", version.getName());
            versionInfos.put("version", version.getVersion());
            versionInfos.put("date", version.getDate() != null ? DateUtils.dateToString(version.getDate()) : null);
            versions.add(versionInfos);
        }
        return versions;
    }

    @Callable
    public String getLicenseText() throws IOException {
        String path = this._cocoonContext.getRealPath(NOTICE_FILE_PATH);
        File licenseFile = new File(path);
        if (licenseFile.exists() && licenseFile.isFile()) {
            StringBuffer sb = new StringBuffer();
            try (BufferedReader reader = new BufferedReader(new FileReader(licenseFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("<br/>");
                }
            }
            catch (FileNotFoundException e) {
                this.getLogger().warn("License file {} is not present at {}", (Object)NOTICE_FILE_PATH, (Object)path);
                return "";
            }
            return sb.toString();
        }
        this.getLogger().warn("License file {} is not present at {}", (Object)NOTICE_FILE_PATH, (Object)path);
        return "";
    }
}

