/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.help;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.core.ui.help.HelpLink;
import org.ametys.plugins.core.ui.help.HelpManager;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class HelpExtensionPoint
extends AbstractLogEnabled
implements ExtensionPoint<String>,
Initializable,
ThreadSafe,
Component,
Serviceable {
    public static final String ROLE = HelpExtensionPoint.class.getName();
    protected Map<String, HelpLink> _links;
    protected Set<String> _points;
    protected HelpManager _helpManager;

    public void initialize() throws Exception {
        this._links = new HashMap<String, HelpLink>();
        this._points = new HashSet<String>();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._helpManager = (HelpManager)manager.lookup(HelpManager.ROLE);
    }

    @Override
    public boolean hasExtension(String id) {
        return this._points.contains(id);
    }

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        this._points.add(id);
        this.getLogger().debug("Adding help URLs from plugin {}/{}", (Object)pluginName, (Object)featureName);
        Map<String, HelpLink> links = this._helpManager.parseConfigFile(configuration, pluginName, featureName);
        for (Map.Entry<String, HelpLink> link : links.entrySet()) {
            if (this._links.containsKey(link.getKey())) {
                this.getLogger().warn("There is already a help key for this point{}id : {}", (Object)"#", (Object)link.getKey());
                continue;
            }
            this._links.put(link.getKey(), link.getValue());
        }
    }

    public HelpLink getHelpLink(String point, String id) {
        String uniqueId = HelpLink.getUniqueId(point, id);
        return this._links.get(uniqueId);
    }

    @Override
    public Set<String> getExtensionsIds() {
        return this._points;
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    @Override
    public String getExtension(String id) {
        if (this._points.contains(id)) {
            return id;
        }
        return null;
    }
}

