/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.log;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.runtime.log.MemoryAppender;
import org.ametys.runtime.log.MemoryLogRecord;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.environment.Context;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class LogManager
implements Component,
Contextualizable {
    public static final String ROLE = LogManager.class.getName();
    public static final String MEMORY_APPENDER_NAME = "memory-appender";
    private String _contextPath;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        Context cocoonContext = (Context)context.get((Object)"environment-context");
        this._contextPath = cocoonContext.getRealPath("/");
        this._contextPath = this._contextPath.replace('\\', '/');
        if (!this._contextPath.endsWith(File.separator)) {
            this._contextPath = this._contextPath + File.separator;
        }
        this._contextPath = "file:" + this._contextPath;
    }

    @Callable
    public List<Map<String, Object>> getEvents(Long timestamp, List<String> categories) {
        Appender appender;
        long timeDelimiter = 0L;
        if (timestamp != null) {
            timeDelimiter = timestamp + 1L;
        }
        if ((appender = Logger.getRootLogger().getAppender(MEMORY_APPENDER_NAME)) == null || !(appender instanceof MemoryAppender)) {
            throw new RuntimeException("Unable to get the Memory Appender from the root logger.");
        }
        MemoryAppender memoryAppender = (MemoryAppender)appender;
        List<MemoryLogRecord> recentEvents = memoryAppender.getEvents(timeDelimiter, categories);
        ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>();
        for (MemoryLogRecord event : recentEvents) {
            HashMap<String, Object> jsonEvent = new HashMap<String, Object>();
            jsonEvent.put("timestamp", event.getMillis());
            jsonEvent.put("category", event.getCategory());
            jsonEvent.put("message", this._hideRealPaths(event.getMessage()));
            jsonEvent.put("location", event.getLocation());
            jsonEvent.put("callstack", this._hideRealPaths(event.getThrownStackTrace()));
            jsonEvent.put("level", event.getLevel().getLabel());
            jsonEvent.put("thread", event.getThreadDescription());
            jsonEvent.put("user", event.getUser());
            jsonEvent.put("requestURI", event.getRequestURI());
            events.add(jsonEvent);
        }
        return events;
    }

    private String _hideRealPaths(String text) {
        if (text == null) {
            return text;
        }
        return text.replace(this._contextPath, "context:/");
    }
}

