/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.minimize;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.plugins.core.ui.resources.ResourceDependenciesListExtensionPoint;
import org.ametys.plugins.core.ui.util.RequestAttributesHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class HashCache
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = HashCache.class.getName();
    protected RequestAttributesHelper _requestAttributesHelper;
    protected ResourceDependenciesListExtensionPoint _resourceDependenciesListEP;
    private Map<String, List<UriData>> _hashCache = new HashMap<String, List<UriData>>();

    public void service(ServiceManager manager) throws ServiceException {
        this._requestAttributesHelper = (RequestAttributesHelper)manager.lookup(RequestAttributesHelper.ROLE);
        this._resourceDependenciesListEP = (ResourceDependenciesListExtensionPoint)manager.lookup(ResourceDependenciesListExtensionPoint.ROLE);
    }

    public List<UriData> getFilesForHash(String hash, boolean firstLevel) {
        if (firstLevel) {
            return this._hashCache.get(hash).stream().filter(UriData::isFirstLevel).collect(Collectors.toList());
        }
        return this._hashCache.get(hash);
    }

    public String createHash(Map<String, Map<String, String>> files, String salt) throws IllegalArgumentException {
        ArrayList hashCache = new ArrayList();
        Map<String, Object> attributes = this._requestAttributesHelper.saveRequestAttributes();
        try {
            files.entrySet().stream().map(file -> this._resourceDependenciesListEP.getDependencies((String)file.getKey(), (Map)file.getValue())).filter(Objects::nonNull).forEach(fileDependencies -> hashCache.addAll(fileDependencies));
            String hash = Base64.getEncoder().withoutPadding().encodeToString(String.valueOf(31 * hashCache.hashCode() + salt.hashCode()).getBytes("UTF-8"));
            this._hashCache.put(hash, hashCache);
            String string = hash;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this._requestAttributesHelper.restoreRequestAttributes(attributes);
        }
    }

    public static class UriData {
        private String _uri;
        private Long _lastModified;
        private String _media;
        private boolean _firstLevel;

        public UriData(String uri, boolean firstLevel) {
            this._uri = uri;
            this._firstLevel = firstLevel;
        }

        public void setLastModified(Long lastModified) {
            this._lastModified = lastModified;
        }

        public void setMedia(String media) {
            this._media = media;
        }

        public String getUri() {
            return this._uri;
        }

        public Long getLastModified() {
            return this._lastModified;
        }

        public String getMedia() {
            return this._media;
        }

        public boolean isFirstLevel() {
            return this._firstLevel;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UriData) {
                UriData fObj = (UriData)obj;
                return StringUtils.equals((CharSequence)this._uri, (CharSequence)fObj._uri) && (this._lastModified == null ? fObj._lastModified == null : this._lastModified.equals(fObj._lastModified)) && StringUtils.equals((CharSequence)this._media, (CharSequence)fObj._media);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this._uri, this._lastModified, this._media);
        }

        public String toString() {
            if (this._media != null) {
                return this._uri + "#" + this._media + " (" + this._lastModified + ")";
            }
            return this._uri + " (" + this._lastModified + ")";
        }
    }
}

