/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.sass;

import io.bit3.jsass.CompilationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.core.minimize.css.sass.MinimizeSassManager;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.resources.AbstractCompiledResourceHandler;
import org.ametys.plugins.core.ui.resources.ResourceDependenciesListExtensionPoint;
import org.ametys.plugins.core.ui.resources.css.sass.SassImportHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;

public class SassResourceHandler
extends AbstractCompiledResourceHandler {
    private static final String[] __SASS_EXTENSION = new String[]{".scss", ".sass"};
    private static final String ADDITIONAL_PARAMETER_LOCATION = "location";
    private static final String ADDITIONAL_PARAMETER_SASS_LOCATION = "sass-location";
    private static final String ADDITIONAL_PARAMETER_MINIMIZE = "minimize";
    protected ResourceDependenciesListExtensionPoint _resourceDependenciesListEP;
    protected MinimizeSassManager _sassMinimizeManager;
    protected SassImportHelper _sassImportHelper;
    protected ProxiedContextPathProvider _proxiedContextPathProvider;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sassMinimizeManager = (MinimizeSassManager)manager.lookup(MinimizeSassManager.ROLE);
        this._resourceDependenciesListEP = (ResourceDependenciesListExtensionPoint)manager.lookup(ResourceDependenciesListExtensionPoint.ROLE);
        this._sassImportHelper = (SassImportHelper)manager.lookup(SassImportHelper.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)manager.lookup(ProxiedContextPathProvider.ROLE);
    }

    @Override
    public int getPriority() {
        return -2147482648;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isSupported(String source) {
        if (!super.isSupported(source)) {
            return false;
        }
        String lcSource = StringUtils.lowerCase((String)source);
        if (lcSource.endsWith(".css")) {
            String sourceWithoutExt = StringUtils.substringBeforeLast((String)source, (String)".css");
            for (String ext : __SASS_EXTENSION) {
                Source src;
                block7: {
                    boolean bl;
                    src = null;
                    try {
                        src = this._resolver.resolveURI(StringUtils.removeEnd((String)sourceWithoutExt, (String)".min") + ext);
                        if (!src.exists()) break block7;
                        bl = true;
                    }
                    catch (IOException iOException) {
                        this._resolver.release(src);
                        continue;
                        catch (Throwable throwable) {
                            this._resolver.release(src);
                            throw throwable;
                        }
                    }
                    this._resolver.release(src);
                    return bl;
                }
                this._resolver.release(src);
            }
            return false;
        }
        return true;
    }

    @Override
    protected Source getCompiledSource(String location, Map<String, Object> additionalParameters) throws MalformedURLException, IOException {
        if (location.toLowerCase().endsWith(".css")) {
            String locationWithoutExt = StringUtils.substringBeforeLast((String)location, (String)".css");
            if (StringUtils.endsWith((CharSequence)locationWithoutExt, (CharSequence)".min")) {
                locationWithoutExt = StringUtils.removeEnd((String)locationWithoutExt, (String)".min");
                additionalParameters.put(ADDITIONAL_PARAMETER_MINIMIZE, true);
            }
            for (String ext : __SASS_EXTENSION) {
                Source src = this._resolver.resolveURI(locationWithoutExt + ext);
                if (!src.exists()) continue;
                additionalParameters.put(ADDITIONAL_PARAMETER_LOCATION, location);
                additionalParameters.put(ADDITIONAL_PARAMETER_SASS_LOCATION, locationWithoutExt + ext);
                return src;
            }
        }
        return this._resolver.resolveURI(location);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws ProcessingException, IOException {
        Source source = super.setup(location, objectModel, par, additionalParameters);
        if (!additionalParameters.containsKey(ADDITIONAL_PARAMETER_SASS_LOCATION)) {
            additionalParameters.put(ADDITIONAL_PARAMETER_SASS_LOCATION, location);
        }
        return source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String compileResource(Source resource, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        try (InputStream is = resource.getInputStream();){
            String sassContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String location = (String)additionalParameters.get(ADDITIONAL_PARAMETER_LOCATION);
            String sassLocation = (String)additionalParameters.get(ADDITIONAL_PARAMETER_SASS_LOCATION);
            boolean minimize = (Boolean)additionalParameters.getOrDefault(ADDITIONAL_PARAMETER_MINIMIZE, false);
            String string = this._sassMinimizeManager.compileCss(sassContent, sassLocation, location, minimize, resource.getLastModified());
            return string;
        }
        catch (CompilationException | URISyntaxException e) {
            throw new ProcessingException("Unable to compile the SASS file: " + resource.getURI(), e);
        }
    }

    @Override
    protected List<String> getDependenciesList(Source inputSource) {
        return new ArrayList<String>(this._sassImportHelper.getDependenciesList(inputSource).keySet());
    }

    @Override
    public String getMimeType(Source source, Parameters par) {
        return "text/css";
    }

    @Override
    public Serializable getKey(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        boolean minimize = (Boolean)additionalParameters.getOrDefault(ADDITIONAL_PARAMETER_MINIMIZE, false);
        return super.getKey(source, objectModel, parameters, additionalParameters) + "*" + (minimize ? "min" : "") + "*" + this._proxiedContextPathProvider.getContextPath();
    }
}

