/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.right;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.core.right.RightAssignmentContextExtensionPoint;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetProfileAssignmentsAction
extends ServiceableAction {
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected RightAssignmentContextExtensionPoint _rightAssignmentContextEP;
    protected RightProfilesDAO _profilesDAO;
    protected UserPopulationDAO _userPopulationDAO;
    protected UserManager _userManager;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected GroupManager _groupManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)smanager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._rightAssignmentContextEP = (RightAssignmentContextExtensionPoint)smanager.lookup(RightAssignmentContextExtensionPoint.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (this._profilesDAO == null) {
            this._profilesDAO = (RightProfilesDAO)this.manager.lookup(RightProfilesDAO.ROLE);
        }
        HashMap result = new HashMap();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Map jsParameters = (Map)objectModel.get("parent-context");
        String rightAssignmentCtxId = (String)jsParameters.get("rightAssignmentContextId");
        RightAssignmentContext rightCtx = (RightAssignmentContext)this._rightAssignmentContextEP.getExtension(rightAssignmentCtxId);
        Object jsContext = jsParameters.get("context");
        Object context = rightCtx.convertJSContext(jsContext);
        List<String> profileIds = (List<String>)jsParameters.get("profileIds");
        if (profileIds == null) {
            profileIds = this._profilesDAO.getProfiles().stream().map(profile -> profile.getId()).collect(Collectors.toList());
        }
        ArrayList<Map<String, Object>> assignments = new ArrayList<Map<String, Object>>();
        assignments.add(this._getAssignmentForAnonymous(rightCtx, context, profileIds));
        assignments.add(this._getAssignmentForAnyConnectedUser(rightCtx, context, profileIds));
        assignments.addAll(this._getAssignmentForUsers(rightCtx, context, context, profileIds).values());
        assignments.addAll(this._getAssignmentForGroups(rightCtx, context, context, profileIds).values());
        result.put("assignments", assignments);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private Map<String, Object> _getAssignmentForAnonymous(RightAssignmentContext rightCtx, Object context, List<String> profileIds) {
        HashMap<String, Object> assignment = new HashMap<String, Object>();
        assignment.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.ANONYMOUS.toString());
        for (String profileId : profileIds) {
            this._getAssignmentForAnonymous(rightCtx, assignment, context, context, profileId);
        }
        return assignment;
    }

    private void _getAssignmentForAnonymous(RightAssignmentContext rightCtx, Map<String, Object> assignment, Object initialContext, Object currentContext, String profileId) {
        Set<String> deniedProfiles = this._profileAssignmentStorageEP.getDeniedProfilesForAnonymous(currentContext);
        if (deniedProfiles.contains(profileId)) {
            assignment.put(profileId, currentContext == initialContext ? ProfileAssignmentsToolClientSideElement.AccessType.DENY.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString());
            return;
        }
        Set<String> allowedProfiles = this._profileAssignmentStorageEP.getAllowedProfilesForAnonymous(currentContext);
        if (allowedProfiles.contains(profileId)) {
            assignment.put(profileId, currentContext == initialContext ? ProfileAssignmentsToolClientSideElement.AccessType.ALLOW.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString());
            return;
        }
        Set<Object> parentContexts = rightCtx.getParentContexts(currentContext);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                HashMap<String, Object> parentAssignment = new HashMap<String, Object>();
                this._getAssignmentForAnonymous(rightCtx, parentAssignment, initialContext, parentContext, profileId);
                String parentValue = (String)parentAssignment.get(profileId);
                if (ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString().equals(parentValue)) {
                    assignment.put(profileId, ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString());
                    return;
                }
                if (!ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString().equals(parentValue)) continue;
                assignment.put(profileId, ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString());
            }
        }
    }

    private Map<String, Object> _getAssignmentForAnyConnectedUser(RightAssignmentContext rightCtx, Object context, List<String> profileIds) {
        HashMap<String, Object> assignment = new HashMap<String, Object>();
        assignment.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.ANYCONNECTED_USER.toString());
        for (String profileId : profileIds) {
            this._getAssignmentForAnyConnectedUser(rightCtx, assignment, context, context, profileId);
        }
        return assignment;
    }

    private void _getAssignmentForAnyConnectedUser(RightAssignmentContext rightCtx, Map<String, Object> assignment, Object initialContext, Object currentContext, String profileId) {
        Set<String> deniedProfiles = this._profileAssignmentStorageEP.getDeniedProfilesForAnyConnectedUser(currentContext);
        if (deniedProfiles.contains(profileId)) {
            assignment.put(profileId, currentContext == initialContext ? ProfileAssignmentsToolClientSideElement.AccessType.DENY.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString());
            return;
        }
        Set<String> allowedProfiles = this._profileAssignmentStorageEP.getAllowedProfilesForAnyConnectedUser(currentContext);
        if (allowedProfiles.contains(profileId)) {
            assignment.put(profileId, currentContext == initialContext ? ProfileAssignmentsToolClientSideElement.AccessType.ALLOW.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString());
            return;
        }
        Set<Object> parentContexts = rightCtx.getParentContexts(currentContext);
        if (parentContexts != null) {
            for (Object parentContext : parentContexts) {
                HashMap<String, Object> parentAssignment = new HashMap<String, Object>();
                this._getAssignmentForAnyConnectedUser(rightCtx, parentAssignment, initialContext, parentContext, profileId);
                String parentValue = (String)parentAssignment.get(profileId);
                if (ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString().equals(parentValue)) {
                    assignment.put(profileId, ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString());
                    return;
                }
                if (!ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString().equals(parentValue)) continue;
                assignment.put(profileId, ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString());
            }
        }
    }

    private Map<UserIdentity, Map<String, Object>> _getAssignmentForUsers(RightAssignmentContext rightCtx, Object initialContext, Object context, List<String> profileIds) {
        LinkedHashMap<UserIdentity, Map<String, Object>> assignments = new LinkedHashMap<UserIdentity, Map<String, Object>>();
        Map<UserIdentity, Set<String>> deniedProfilesForUsers = this._profileAssignmentStorageEP.getDeniedProfilesForUsers(context);
        for (UserIdentity userIdentity : deniedProfilesForUsers.keySet()) {
            this._getAssignementForDeniedUser(initialContext, profileIds, assignments, context, deniedProfilesForUsers, userIdentity);
        }
        Map<UserIdentity, Set<String>> allowedProfilesForUsers = this._profileAssignmentStorageEP.getAllowedProfilesForUsers(context);
        for (UserIdentity userIdentity : allowedProfilesForUsers.keySet()) {
            this._getAssignementForAllowedUser(initialContext, profileIds, assignments, context, allowedProfilesForUsers, userIdentity);
        }
        Set<Object> set = rightCtx.getParentContexts(context);
        if (set != null) {
            HashMap<UserIdentity, Map<String, Object>> allParentsAssignments = new HashMap<UserIdentity, Map<String, Object>>();
            for (Object parentContext : set) {
                Map<UserIdentity, Map<String, Object>> parentAssignment = this._getAssignmentForUsers(rightCtx, initialContext, parentContext, profileIds);
                this._mergeUser(allParentsAssignments, parentAssignment, false);
            }
            this._mergeUser(assignments, allParentsAssignments, true);
        }
        return assignments;
    }

    private void _getAssignementForAllowedUser(Object context, List<String> profileIds, Map<UserIdentity, Map<String, Object>> assignments, Object currentContext, Map<UserIdentity, Set<String>> allowedProfilesForUsers, UserIdentity userIdentity) {
        User user = this._userManager.getUser(userIdentity);
        if (user != null) {
            if (!assignments.containsKey(userIdentity)) {
                assignments.put(userIdentity, this._user2json(user));
            }
            Map<String, Object> userAssignment = assignments.get(userIdentity);
            for (String profileId : allowedProfilesForUsers.get(userIdentity)) {
                if (!profileIds.contains(profileId) || userAssignment.containsKey(profileId)) continue;
                userAssignment.put(profileId, currentContext == context ? ProfileAssignmentsToolClientSideElement.AccessType.ALLOW.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString());
            }
        }
    }

    private void _getAssignementForDeniedUser(Object context, List<String> profileIds, Map<UserIdentity, Map<String, Object>> assignments, Object currentContext, Map<UserIdentity, Set<String>> deniedProfilesForUsers, UserIdentity userIdentity) {
        User user = this._userManager.getUser(userIdentity);
        if (user != null) {
            Map<String, Object> user2json;
            if (!assignments.containsKey(userIdentity) && (user2json = this._user2json(user)) != null) {
                assignments.put(userIdentity, user2json);
            }
            Map<String, Object> userAssignment = assignments.get(userIdentity);
            for (String profileId : deniedProfilesForUsers.get(userIdentity)) {
                if (!profileIds.contains(profileId) || userAssignment.containsKey(profileId)) continue;
                userAssignment.put(profileId, currentContext == context ? ProfileAssignmentsToolClientSideElement.AccessType.DENY.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString());
            }
        }
    }

    private Map<GroupIdentity, Map<String, Object>> _getAssignmentForGroups(RightAssignmentContext rightCtx, Object initialContext, Object context, List<String> profileIds) {
        LinkedHashMap<GroupIdentity, Map<String, Object>> assignments = new LinkedHashMap<GroupIdentity, Map<String, Object>>();
        Map<GroupIdentity, Set<String>> deniedProfilesForGroups = this._profileAssignmentStorageEP.getDeniedProfilesForGroups(context);
        for (GroupIdentity groupIdentity : deniedProfilesForGroups.keySet()) {
            this._getAssignmentForDeniedGroup(initialContext, profileIds, assignments, context, deniedProfilesForGroups, groupIdentity);
        }
        Map<GroupIdentity, Set<String>> allowedProfilesForGroups = this._profileAssignmentStorageEP.getAllowedProfilesForGroups(context);
        for (GroupIdentity gpIdentity : allowedProfilesForGroups.keySet()) {
            this._getAssignementForAllowedGroup(initialContext, profileIds, assignments, context, allowedProfilesForGroups, gpIdentity);
        }
        Set<Object> set = rightCtx.getParentContexts(context);
        if (set != null) {
            HashMap<GroupIdentity, Map<String, Object>> allParentsAssignments = new HashMap<GroupIdentity, Map<String, Object>>();
            for (Object parentContext : set) {
                Map<GroupIdentity, Map<String, Object>> parentAssignment = this._getAssignmentForGroups(rightCtx, initialContext, parentContext, profileIds);
                this._mergeGroup(allParentsAssignments, parentAssignment, false);
            }
            this._mergeGroup(assignments, allParentsAssignments, true);
        }
        return assignments;
    }

    private void _mergeUser(Map<UserIdentity, Map<String, Object>> finalAssignments, Map<UserIdentity, Map<String, Object>> parentsAssignments, boolean finalListPrevails) {
        for (UserIdentity identity : parentsAssignments.keySet()) {
            if (!finalAssignments.containsKey(identity)) {
                finalAssignments.put(identity, parentsAssignments.get(identity));
                continue;
            }
            for (String profileId : parentsAssignments.get(identity).keySet()) {
                Object assignmentsValue = finalAssignments.get(identity).get(profileId);
                Object allParentsAssignmentsValue = parentsAssignments.get(identity).get(profileId);
                if (assignmentsValue != null && !ProfileAssignmentsToolClientSideElement.AccessType.UNKNOWN.toString().equals(assignmentsValue) && (finalListPrevails || !ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString().equals(assignmentsValue) || ProfileAssignmentsToolClientSideElement.AccessType.UNKNOWN.toString().equals(allParentsAssignmentsValue))) continue;
                finalAssignments.get(identity).put(profileId, allParentsAssignmentsValue);
            }
        }
    }

    private void _mergeGroup(Map<GroupIdentity, Map<String, Object>> finalAssignments, Map<GroupIdentity, Map<String, Object>> parentsAssignments, boolean finalListPrevails) {
        for (GroupIdentity identity : parentsAssignments.keySet()) {
            if (!finalAssignments.containsKey(identity)) {
                finalAssignments.put(identity, parentsAssignments.get(identity));
                continue;
            }
            for (String profileId : parentsAssignments.get(identity).keySet()) {
                Object assignmentsValue = finalAssignments.get(identity).get(profileId);
                Object allParentsAssignmentsValue = parentsAssignments.get(identity).get(profileId);
                if (assignmentsValue != null && !ProfileAssignmentsToolClientSideElement.AccessType.UNKNOWN.toString().equals(assignmentsValue) && (finalListPrevails || !ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString().equals(assignmentsValue) || ProfileAssignmentsToolClientSideElement.AccessType.UNKNOWN.toString().equals(allParentsAssignmentsValue))) continue;
                finalAssignments.get(identity).put(profileId, allParentsAssignmentsValue);
            }
        }
    }

    private void _getAssignementForAllowedGroup(Object context, List<String> profileIds, Map<GroupIdentity, Map<String, Object>> assignments, Object currentContext, Map<GroupIdentity, Set<String>> allowedProfilesForGroups, GroupIdentity gpIdentity) {
        Group group = this._groupManager.getGroup(gpIdentity.getDirectoryId(), gpIdentity.getId());
        if (group != null) {
            if (!assignments.containsKey(gpIdentity)) {
                assignments.put(gpIdentity, this._group2json(group));
            }
            Map<String, Object> gpAssignment = assignments.get(gpIdentity);
            for (String profileId : allowedProfilesForGroups.get(gpIdentity)) {
                if (!profileIds.contains(profileId) || gpAssignment.containsKey(profileId)) continue;
                gpAssignment.put(profileId, currentContext == context ? ProfileAssignmentsToolClientSideElement.AccessType.ALLOW.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_ALLOW.toString());
            }
        }
    }

    private void _getAssignmentForDeniedGroup(Object context, List<String> profileIds, Map<GroupIdentity, Map<String, Object>> assignments, Object currentContext, Map<GroupIdentity, Set<String>> deniedProfilesForGroups, GroupIdentity gpIdentity) {
        Group group = this._groupManager.getGroup(gpIdentity.getDirectoryId(), gpIdentity.getId());
        if (group != null) {
            if (!assignments.containsKey(gpIdentity)) {
                assignments.put(gpIdentity, this._group2json(group));
            }
            Map<String, Object> gpAssignment = assignments.get(gpIdentity);
            for (String profileId : deniedProfilesForGroups.get(gpIdentity)) {
                if (!profileIds.contains(profileId) || gpAssignment.containsKey(profileId)) continue;
                gpAssignment.put(profileId, currentContext == context ? ProfileAssignmentsToolClientSideElement.AccessType.DENY.toString() : ProfileAssignmentsToolClientSideElement.AccessType.INHERITED_DENY.toString());
            }
        }
    }

    private Map<String, Object> _user2json(User user) {
        HashMap<String, Object> assignment = new HashMap<String, Object>();
        assignment.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.USER.toString());
        String login = user.getIdentity().getLogin();
        String populationId = user.getIdentity().getPopulationId();
        assignment.put("login", login);
        assignment.put("populationId", populationId);
        assignment.put("populationLabel", this._userPopulationDAO.getUserPopulation(populationId).getLabel());
        assignment.put("groups", this._groupManager.getUserGroups(user.getIdentity()).stream().map(this::_userGroup2json).collect(Collectors.toList()));
        assignment.put("userSortableName", user.getSortableName());
        return assignment;
    }

    private Map<String, Object> _group2json(Group group) {
        HashMap<String, Object> assignment = new HashMap<String, Object>();
        assignment.put("targetType", ProfileAssignmentsToolClientSideElement.TargetType.GROUP.toString());
        String groupId = group.getIdentity().getId();
        String directoryId = group.getIdentity().getDirectoryId();
        assignment.put("groupId", groupId);
        assignment.put("groupDirectory", directoryId);
        assignment.put("groupDirectoryLabel", this._groupDirectoryDAO.getGroupDirectory(directoryId).getLabel());
        assignment.put("groupLabel", group.getLabel());
        return assignment;
    }

    private Map<String, Object> _userGroup2json(GroupIdentity group) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("groupId", group.getId());
        result.put("groupDirectory", group.getDirectoryId());
        return result;
    }
}

