/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class ConfigurationHelper {
    private ConfigurationHelper() {
    }

    public static List<ClientSideElement.ScriptFile> parsePluginResourceList(Configuration configuration, String defaultPluginName, Logger logger) throws ConfigurationException {
        ArrayList<ClientSideElement.ScriptFile> resourceFiles = new ArrayList<ClientSideElement.ScriptFile>();
        String listDefaultPlugin = configuration.getAttribute("plugin", defaultPluginName);
        for (Configuration fileConfiguration : configuration.getChildren("file")) {
            ClientSideElement.ScriptFile scriptFile = ConfigurationHelper._getPluginResourceValue(fileConfiguration, listDefaultPlugin, logger);
            resourceFiles.add(scriptFile);
        }
        return resourceFiles;
    }

    private static ClientSideElement.ScriptFile _getPluginResourceValue(Configuration fileConfiguration, String listDefaultPlugin, Logger logger) throws ConfigurationException {
        ClientSideElement.ScriptFile scriptFile;
        boolean langAware = fileConfiguration.getAttributeAsBoolean("lang", false);
        if (langAware) {
            String defaultLang = fileConfiguration.getAttribute("defaultLang", null);
            HashMap<String, String> langPaths = new HashMap<String, String>();
            for (Configuration langConfiguration : fileConfiguration.getChildren("lang")) {
                String code = langConfiguration.getAttribute("code", null);
                if (StringUtils.isBlank((CharSequence)code)) {
                    throw new ConfigurationException("Code attribute is mandatory for lang tag", langConfiguration);
                }
                String path = ConfigurationHelper._getPluginResourceValue(langConfiguration, listDefaultPlugin, langConfiguration.getValue(), logger);
                langPaths.put(code, path);
            }
            scriptFile = new ClientSideElement.ScriptFile(langPaths, defaultLang);
        } else {
            String rtl = fileConfiguration.getAttribute("rtl", "all");
            String path = ConfigurationHelper._getPluginResourceValue(fileConfiguration, listDefaultPlugin, fileConfiguration.getValue(), logger);
            scriptFile = new ClientSideElement.ScriptFile(rtl, path);
        }
        return scriptFile;
    }

    public static String parsePluginResource(Configuration configuration, String defaultPluginName, Logger logger) throws ConfigurationException {
        String url = configuration.getValue();
        return ConfigurationHelper._getPluginResourceValue(configuration, defaultPluginName, url, logger);
    }

    public static String parsePluginResource(Configuration configuration, String defaultPluginName, String defaultValue, Logger logger) {
        String url = configuration.getValue(defaultValue);
        return ConfigurationHelper._getPluginResourceValue(configuration, defaultPluginName, url, logger);
    }

    private static String _getPluginResourceValue(Configuration configuration, String defaultPluginName, String value, Logger logger) {
        String pluginName = configuration.getAttribute("plugin", defaultPluginName);
        String fullUrl = "/plugins/" + pluginName + "/resources/" + value;
        if (logger.isDebugEnabled()) {
            logger.debug("Importing file '" + fullUrl + "'");
        }
        return fullUrl;
    }

    public static List<String> parsePluginResourceUri(Configuration configuration, String defaultPluginName, Logger logger) throws ConfigurationException {
        ArrayList<String> fileURIs = new ArrayList<String>();
        String listDefaultPlugin = configuration.getAttribute("plugin", defaultPluginName);
        for (Configuration fileConfiguration : configuration.getChildren("file")) {
            String fileURI = ConfigurationHelper._getPluginResourceUri(fileConfiguration, listDefaultPlugin, logger);
            fileURIs.add(fileURI);
        }
        return fileURIs;
    }

    private static String _getPluginResourceUri(Configuration configuration, String defaultPluginName, Logger logger) throws ConfigurationException {
        String pluginName = configuration.getAttribute("plugin", defaultPluginName);
        String value = configuration.getValue();
        String fullUrl = "plugin:" + pluginName + "://" + value;
        if (logger.isDebugEnabled()) {
            logger.debug("Importing file uri '" + fullUrl + "'");
        }
        return fullUrl;
    }

    public static String parseConfigParameter(Configuration configuration) throws ConfigurationException {
        return ConfigurationHelper._getConfigParameterValue(configuration.getValue());
    }

    public static String parseConfigParameter(Configuration configuration, String defaultValue) {
        return ConfigurationHelper._getConfigParameterValue(configuration.getValue(defaultValue));
    }

    private static String _getConfigParameterValue(String value) {
        return (String)Config.getInstance().getValue(value);
    }

    public static Object parseObject(Configuration configuration) {
        return ConfigurationHelper.parseObject(configuration, null);
    }

    public static Object parseObject(Configuration configuration, Object defaultValue) {
        String value = configuration.getValue(null);
        Configuration[] children = configuration.getChildren();
        if (value != null) {
            return value;
        }
        if (children.length > 0) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Configuration subConf : children) {
                boolean multiple;
                String name = subConf.getName();
                Object subValue = ConfigurationHelper.parseObject(subConf, defaultValue);
                boolean bl = multiple = configuration.getChildren(name).length > 1;
                if (multiple) {
                    List<Object> values = null;
                    if (result.containsKey(name)) {
                        values = (List)result.get(name);
                    } else {
                        values = new ArrayList();
                        result.put(name, values);
                    }
                    values.add(subValue);
                    continue;
                }
                result.put(name, subValue);
            }
            return result;
        }
        return defaultValue;
    }

    public static Map<String, Object> parsePluginParameters(Configuration configuration, String defaultPluginName, Logger logger) throws ConfigurationException {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        for (Configuration paramConfiguration : configuration.getChildren()) {
            String name = paramConfiguration.getName().equals("param") ? paramConfiguration.getAttribute("name") : paramConfiguration.getName();
            String value = paramConfiguration.getValue("");
            if (logger.isDebugEnabled()) {
                logger.debug("Configured with parameter '" + name + "' : '" + value + "'");
            }
            if (ConfigurationHelper.isI18n(paramConfiguration)) {
                ConfigurationHelper.addParameter(parameters, name, I18nizableText.getI18nizableTextValue(paramConfiguration, "plugin." + defaultPluginName, value));
                continue;
            }
            if (ConfigurationHelper.isResourceFile(paramConfiguration)) {
                ConfigurationHelper.addParameter(parameters, name, ConfigurationHelper._getPluginResourceValue(paramConfiguration, defaultPluginName, value, logger));
                continue;
            }
            if (ConfigurationHelper.isConfigParameter(paramConfiguration)) {
                ConfigurationHelper.addParameter(parameters, name, ConfigurationHelper._getConfigParameterValue(value));
                continue;
            }
            if (paramConfiguration.getChildren().length != 0) {
                ConfigurationHelper.addParameter(parameters, name, ConfigurationHelper.parsePluginParameters(paramConfiguration, defaultPluginName, logger));
                continue;
            }
            ConfigurationHelper.addParameter(parameters, name, value);
        }
        return parameters;
    }

    public static Map<String, Object> clonePluginParameters(Map<String, Object> parameters) {
        LinkedHashMap<String, Object> clonedParameters = new LinkedHashMap<String, Object>();
        for (String name : parameters.keySet()) {
            Object value = parameters.get(name);
            clonedParameters.put(name, ConfigurationHelper._clonePluginParameter(value));
        }
        return clonedParameters;
    }

    private static Object _clonePluginParameter(Object value) {
        if (value instanceof I18nizableText || value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Double) {
            return value;
        }
        if (value instanceof LinkedHashMap) {
            return ConfigurationHelper.clonePluginParameters((Map)value);
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object v : (List)value) {
                list.add(ConfigurationHelper._clonePluginParameter(v));
            }
            return list;
        }
        throw new IllegalArgumentException("Cannot clone a parameter of type '" + value.getClass().getName() + "'");
    }

    private static void addParameter(Map<String, Object> parameters, String name, Object newValue) {
        if (parameters.containsKey(name)) {
            Object values = parameters.get(name);
            if (values instanceof List) {
                ((List)values).add(newValue);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(values);
                list.add(newValue);
                parameters.put(name, list);
            }
        } else {
            parameters.put(name, newValue);
        }
    }

    private static boolean isResourceFile(Configuration config) {
        return config.getAttributeAsBoolean("file", false) || config.getAttribute("type", "").equals("file");
    }

    private static boolean isConfigParameter(Configuration config) {
        return config.getAttributeAsBoolean("config", false) || config.getAttribute("type", "").equals("config");
    }

    private static boolean isI18n(Configuration config) {
        return config.getAttributeAsBoolean("i18n", false) || config.getAttribute("type", "").equals("i18n");
    }
}

