/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableAction;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.lang.exception.ExceptionUtils;

public class UploadAction
extends AbstractCurrentUserProviderServiceableAction {
    private UploadManager _uploadManager;

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (this._uploadManager == null) {
            this._uploadManager = (UploadManager)this.manager.lookup(UploadManager.ROLE);
        }
        Part partUploaded = (Part)request.get("file");
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (partUploaded == null) {
            throw new Exception("Missing request parameter file");
        }
        if (partUploaded.isRejected()) {
            result.put("success", false);
            result.put("error", "rejected");
        } else {
            Upload upload = null;
            try (InputStream is = partUploaded.getInputStream();){
                upload = this._uploadManager.storeUpload(this._getCurrentUser(), partUploaded.getFileName(), is);
                result.put("success", true);
                result.put("id", upload.getId());
                result.put("filename", upload.getFilename());
                result.put("size", upload.getLength());
                result.put("viewHref", this._getUrlForView(upload));
                result.put("downloadHref", this._getUrlForDownload(upload));
            }
            catch (IOException e) {
                this.getLogger().error("Unable to store uploaded file: " + partUploaded, (Throwable)e);
                result.put("success", false);
                HashMap<String, String> ex = new HashMap<String, String>();
                ex.put("message", e.getMessage());
                ex.put("stacktrace", ExceptionUtils.getFullStackTrace((Throwable)e));
                result.put("error", ex);
            }
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected String _getUrlForView(Upload upload) {
        return "/plugins/core/upload/file?id=" + upload.getId();
    }

    protected String _getUrlForDownload(Upload upload) {
        return "/plugins/core/upload/file?id=" + upload.getId() + "&download=true";
    }
}

