/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.ImageHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class UploadReader
extends ServiceableReader {
    private CurrentUserProvider _currentUserProvider;
    private UploadManager _uploadManager;
    private Upload _upload;
    private int _width;
    private int _height;
    private int _maxWidth;
    private int _maxHeight;
    private boolean _readForDownload;
    private final Collection<String> _allowedFormats = Arrays.asList("png", "gif", "jpg", "jpeg");

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._uploadManager = (UploadManager)serviceManager.lookup(UploadManager.ROLE);
    }

    public void recycle() {
        super.recycle();
        this._upload = null;
    }

    public void setup(SourceResolver res, Map objModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(res, objModel, src, par);
        Request request = ObjectModelHelper.getRequest((Map)objModel);
        String uploadId = request.getParameter("id");
        try {
            this._upload = this._uploadManager.getUpload(this._currentUserProvider.getUser(), uploadId);
        }
        catch (NoSuchElementException e) {
            this.getLogger().warn("Cannot find the temporary uploaded file with id " + (uploadId != null ? "'" + uploadId + "'" : "<null>"));
        }
        this._readForDownload = par.getParameterAsBoolean("download", false);
        this._width = par.getParameterAsInteger("width", 0);
        this._height = par.getParameterAsInteger("height", 0);
        this._maxWidth = par.getParameterAsInteger("maxWidth", 0);
        this._maxHeight = par.getParameterAsInteger("maxHeight", 0);
    }

    public long getLastModified() {
        if (this._upload != null) {
            return this._upload.getUploadedDate().getTime();
        }
        return super.getLastModified();
    }

    public String getMimeType() {
        if (this._upload != null) {
            return this._upload.getMimeType();
        }
        return super.getMimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        if (this._upload == null) {
            throw new ResourceNotFoundException("No upload for source: " + this.source);
        }
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        if (this._readForDownload) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + this._upload.getFilename() + "\"");
        }
        try (InputStream is = this._upload.getInputStream();){
            if (this._isImage()) {
                int i = this._upload.getFilename().lastIndexOf(46);
                String format = i != -1 ? this._upload.getFilename().substring(i + 1).toLowerCase() : "png";
                format = this._allowedFormats.contains(format) ? format : "png";
                ImageHelper.generateThumbnail(is, this.out, format, this._height, this._width, this._maxHeight, this._maxWidth);
            } else {
                response.setHeader("Content-Length", Long.toString(this._upload.getLength()));
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }

    protected boolean _isImage() {
        if (this._width > 0 || this._height > 0 || this._maxHeight > 0 || this._maxWidth > 0) {
            return true;
        }
        return this.getMimeType() != null && this.getMimeType().startsWith("image/");
    }
}

