/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class UserSearchAction
extends AbstractAction
implements ThreadSafe,
Serviceable {
    private static final int _DEFAULT_COUNT_VALUE = 100;
    private static final int _DEFAULT_OFFSET_VALUE = 0;
    private UserManager _userManager;
    private UserHelper _userHelper;
    private CurrentUserProvider _userProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._userProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        ArrayList<Map<String, Object>> users = new ArrayList<Map<String, Object>>();
        if (this._userProvider.getUser() == null) {
            throw new AccessDeniedException("Anonymous user tried to access to users list");
        }
        List contexts = (List)jsParameters.get("contexts");
        if (contexts != null) {
            this._searchUsersByContext(users, jsParameters, source, parameters, new HashSet<String>(contexts));
        } else {
            String userPopulationId = (String)jsParameters.get("userPopulationId");
            String userDirectoryId = null;
            if (jsParameters.get("userDirectoryId") != null) {
                userDirectoryId = (String)jsParameters.get("userDirectoryId");
                userDirectoryId = "-".equals(userDirectoryId) ? null : userDirectoryId;
            }
            this._searchUsersByPopulation(users, jsParameters, source, parameters, userPopulationId, userDirectoryId);
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("users", users);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Map<String, Object> _getSearchParameters(String source) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pattern", source);
        return params;
    }

    private void _searchUsersByContext(List<Map<String, Object>> users, Map<String, Object> jsParameters, String source, Parameters parameters, Set<String> contexts) {
        if (jsParameters.get("login") != null) {
            List logins = (List)jsParameters.get("login");
            for (String login : logins) {
                users.add(this._userHelper.user2json(this._userManager.getUserByContext(contexts, login, true), true));
            }
        } else if (jsParameters.get("value") != null) {
            String[] values;
            for (String value : values = ((String)jsParameters.get("value")).split(",")) {
                String login = StringUtils.substringBeforeLast((String)value, (String)"#");
                String populationId = StringUtils.substringAfterLast((String)value, (String)"#");
                users.add(this._userHelper.user2json(new UserIdentity(login, populationId), true));
            }
        } else {
            int count = parameters.getParameterAsInteger("limit", 100);
            if (count == -1) {
                count = Integer.MAX_VALUE;
            }
            int offset = parameters.getParameterAsInteger("start", 0);
            List<User> usersByContext = this._userManager.getUsersByContext(contexts, count, offset, this._getSearchParameters(source), true);
            users.addAll(this._userHelper.users2json(usersByContext, true));
        }
    }

    private void _searchUsersByPopulation(List<Map<String, Object>> users, Map<String, Object> jsParameters, String source, Parameters parameters, String userPopulationId, String userDirectoryId) {
        if (jsParameters.get("login") != null && userDirectoryId != null) {
            List logins = (List)jsParameters.get("login");
            for (String login : logins) {
                users.add(this._userHelper.user2json(this._userManager.getUserByDirectory(userPopulationId, userDirectoryId, login), true));
            }
        } else if (jsParameters.get("login") != null) {
            List logins = (List)jsParameters.get("login");
            for (String login : logins) {
                users.add(this._userHelper.user2json(this._userManager.getUser(userPopulationId, login), true));
            }
        } else if (userDirectoryId != null) {
            int count = parameters.getParameterAsInteger("limit", 100);
            if (count == -1) {
                count = Integer.MAX_VALUE;
            }
            int offset = parameters.getParameterAsInteger("start", 0);
            users.addAll(this._userHelper.users2json(this._userManager.getUsersByDirectory(userPopulationId, userDirectoryId, count, offset, this._getSearchParameters(source)), true));
        } else {
            int count = parameters.getParameterAsInteger("limit", 100);
            if (count == -1) {
                count = Integer.MAX_VALUE;
            }
            int offset = parameters.getParameterAsInteger("start", 0);
            users.addAll(this._userHelper.users2json(this._userManager.getUsers(userPopulationId, count, offset, this._getSearchParameters(source)), true));
        }
    }
}

