/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.userpref;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.ParameterHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class GetUserPreferencesAction
extends ServiceableAction {
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected UserPreferencesManager _userPrefManager;
    private CurrentUserProvider _currentUserProvider;

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (this._userPrefEP == null) {
            this._userPrefEP = (UserPreferencesExtensionPoint)this.manager.lookup(UserPreferencesExtensionPoint.ROLE);
            this._userPrefManager = (UserPreferencesManager)((Object)this.manager.lookup(UserPreferencesManager.ROLE));
            this._currentUserProvider = (CurrentUserProvider)this.manager.lookup(CurrentUserProvider.ROLE);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String storageContext = parameters.getParameter("prefContext", request.getParameter("prefContext"));
        boolean excludePrivate = parameters.getParameterAsBoolean("excludePrivate", false);
        Map<String, String> contextVars = this.getContextVars(request);
        UserIdentity user = this.getUser(parameters);
        if (StringUtils.isBlank((String)storageContext)) {
            throw new ProcessingException("Preferences context can't be blank");
        }
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("username", user.getLogin());
        jsonObject.put("userpopulation", user.getPopulationId());
        jsonObject.put("context", storageContext);
        jsonObject.put("preferences", this.userPrefs2JsonObject(storageContext, contextVars, user, excludePrivate));
        request.setAttribute(JSonReader.OBJECT_TO_READ, jsonObject);
        return EMPTY_MAP;
    }

    protected Map<String, Object> userPrefs2JsonObject(String storageContext, Map<String, String> contextVars, UserIdentity user, boolean excludePrivate) throws ProcessingException, UserPreferencesException {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        jsonObject.put("fieldsets", new ArrayList());
        Map<I18nizableText, List<UserPreference>> groups = this._userPrefEP.getCategorizedPreferences(contextVars);
        Map<String, String> prefValues = this._userPrefManager.getUnTypedUserPrefs(user, storageContext, contextVars);
        for (Map.Entry<I18nizableText, List<UserPreference>> groupEntry : groups.entrySet()) {
            LinkedHashMap<String, Object> fieldSetObject = new LinkedHashMap<String, Object>();
            fieldSetObject.put("role", "fieldset");
            fieldSetObject.put("label", groupEntry.getKey());
            fieldSetObject.put("elements", this.userPrefs2JsonObject(groupEntry.getValue(), prefValues, excludePrivate));
            List fieldsets = (List)jsonObject.get("fieldsets");
            fieldsets.add(fieldSetObject);
        }
        return jsonObject;
    }

    protected Map<String, Object> userPrefs2JsonObject(List<UserPreference> userPrefs, Map<String, String> prefValues, boolean excludePrivate) throws ProcessingException {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        for (UserPreference userPref : userPrefs) {
            if (excludePrivate && userPref.isPrivate()) continue;
            jsonObject.put(userPref.getId(), this.userPref2JsonObject(userPref, prefValues.get(userPref.getId())));
        }
        return jsonObject;
    }

    protected Map<String, Object> userPref2JsonObject(UserPreference userPref, Object value) throws ProcessingException {
        Map<String, Object> jsonObject = ParameterHelper.toJSON(userPref);
        jsonObject.put("private", userPref.isPrivate());
        jsonObject.put("multiple", userPref.isMultiple());
        if (value != null) {
            jsonObject.put("value", value);
        } else {
            jsonObject.put("value", userPref.getDefaultValue());
        }
        return jsonObject;
    }

    protected UserIdentity getUser(Parameters parameters) {
        String login = parameters.getParameter("username", "");
        String populationId = parameters.getParameter("populationId", "");
        UserIdentity user = StringUtils.isEmpty((String)login) || StringUtils.isEmpty((String)populationId) ? this._currentUserProvider.getUser() : new UserIdentity(login, populationId);
        return user;
    }

    protected Map<String, String> getContextVars(Request request) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("workspace", (String)request.getAttribute("workspaceName"));
        return contextVars;
    }
}

